/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.orphedomos.util.credential;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.technologybrewery.orphedomos.util.OrphedomosException;
import org.technologybrewery.orphedomos.util.credential.MavenPasswordDecoder;

public final class CredentialUtil {
    private static final Logger logger = LoggerFactory.getLogger(CredentialUtil.class);

    private CredentialUtil() {
    }

    public static String findUsernameForServer(Settings settings, String serverId) {
        Server server = settings.getServer(serverId);
        return server != null ? server.getUsername() : null;
    }

    public static String findPlaintextPasswordForServer(Settings settings, String serverId) {
        Server server = settings.getServer(serverId);
        return server != null ? server.getPassword() : null;
    }

    public static String decryptServerPassword(Settings settings, String serverId) {
        String decryptedPassword = null;
        try {
            decryptedPassword = MavenPasswordDecoder.decryptPasswordForServer(settings, serverId);
        }
        catch (PlexusCipherException | SecDispatcherException e) {
            throw new OrphedomosException("Unable to decrypt stored passwords. Make sure you have a master password set in settings-security.xml and your server password is encrypted with it in settings.xml. See https://maven.apache.org/guides/mini/guide-encryption.html for more details.", e);
        }
        return decryptedPassword;
    }

    public static void runBashScript(String bashScriptPath) {
        CredentialUtil.runBashScript(bashScriptPath, null, true);
    }

    public static void runBashScript(String bashScriptPath, String[] parameters, boolean debug) {
        String[] command;
        logger.debug("Running bash script located at {}.", (Object)bashScriptPath);
        if (parameters != null && parameters.length > 0) {
            command = new String[parameters.length + 1];
            System.arraycopy(parameters, 0, command, 1, parameters.length);
        } else {
            command = new String[1];
        }
        if (StringUtils.isNotBlank((String)bashScriptPath)) {
            command[0] = bashScriptPath;
            Process process = null;
            try {
                String line;
                process = Runtime.getRuntime().exec(command);
                StringBuilder output = new StringBuilder();
                BufferedReader stdInReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = stdInReader.readLine()) != null) {
                    output.append(line + "\n");
                }
                BufferedReader stdErrReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = stdErrReader.readLine()) != null) {
                    output.append(line + "\n");
                }
                logger.info(output.toString());
                int exitVal = process.waitFor();
                if (exitVal != 0) {
                    throw new OrphedomosException("Error encountered when running bash script located at " + bashScriptPath + "\n    Can run maven build with -X to see the output of the failed script.");
                }
            }
            catch (IOException | InterruptedException e) {
                throw new OrphedomosException("Could not run bash script.", e);
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
    }

    public static void writeLinesToFile(String commands, String filePath) {
        logger.debug("Writing lines to file located at {}.", (Object)filePath);
        String noTraversalFilePath = FilenameUtils.getFullPath((String)filePath);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(noTraversalFilePath, new String[0]), Charset.defaultCharset(), new OpenOption[0]);){
            writer.write(commands);
        }
        catch (IOException e) {
            throw new OrphedomosException("Could not write to file.", e);
        }
    }

    public static void createFileAndGivePermissions(File newFile) {
        logger.debug("Creating new file at {}.", (Object)newFile.getAbsolutePath());
        if (!newFile.exists()) {
            try {
                newFile.createNewFile();
            }
            catch (IOException e) {
                throw new OrphedomosException("Could not create new file.", e);
            }
        }
        CredentialUtil.giveFullFilePermissions(newFile.getAbsolutePath());
    }

    public static void giveFullFilePermissions(String filePath) {
        File file = new File(FilenameUtils.getName((String)filePath));
        if (file.exists()) {
            file.setExecutable(true, false);
            file.setReadable(true, false);
            file.setWritable(true, false);
        }
    }
}

