/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.orphedomos.util.credential;

import java.io.File;
import java.util.List;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class MavenPasswordDecoder {
    private static final File ORIGINAL_SETTINGS_SECURITY_FILE = new File(System.getProperty("user.home"), ".m2/settings-security.xml");

    private MavenPasswordDecoder() {
    }

    private static String decodePassword(String encodedPassword, String key) throws PlexusCipherException {
        DefaultPlexusCipher cipher = new DefaultPlexusCipher();
        return cipher.decryptDecorated(encodedPassword, key);
    }

    private static String decodeMasterPassword(String encodedMasterPassword) throws PlexusCipherException {
        return MavenPasswordDecoder.decodePassword(encodedMasterPassword, "settings.security");
    }

    private static SettingsSecurity readSettingsSecurity(File file) throws SecDispatcherException {
        return SecUtil.read((String)file.getAbsolutePath(), (boolean)true);
    }

    public static String decryptPasswordForServer(Settings settings, String serverId) throws SecDispatcherException, PlexusCipherException {
        SettingsSecurity settingsSecurity = null;
        if (System.getProperty("settings.security") != null) {
            File movedSettingsSecurityFile = new File(System.getProperty("settings.security"));
            settingsSecurity = MavenPasswordDecoder.readSettingsSecurity(movedSettingsSecurityFile);
        } else if (ORIGINAL_SETTINGS_SECURITY_FILE.exists()) {
            settingsSecurity = MavenPasswordDecoder.readSettingsSecurity(ORIGINAL_SETTINGS_SECURITY_FILE);
        }
        if (settingsSecurity != null) {
            String encodedMasterPassword = settingsSecurity.getMaster();
            String plainTextMasterPassword = MavenPasswordDecoder.decodeMasterPassword(encodedMasterPassword);
            List servers = settings.getServers();
            for (Server server : servers) {
                if (!serverId.equals(server.getId())) continue;
                String encodedServerPassword = server.getPassword();
                String plainTextServerPassword = MavenPasswordDecoder.decodePassword(encodedServerPassword, plainTextMasterPassword);
                return plainTextServerPassword;
            }
        }
        return null;
    }
}

