/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.orphedomos.util.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.orphedomos.util.exec.Platform;
import org.technologybrewery.orphedomos.util.exec.ProcessExecutor;

public class DockerCommandExecutor {
    private static final String DOCKER_COMMAND = "docker";
    private static final Logger logger = LoggerFactory.getLogger(DockerCommandExecutor.class);
    private final File workingDirectory;

    public DockerCommandExecutor(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public int executeWithSensitiveArgsAndLogOutput(List<Pair<String, Boolean>> argAndIsSensitivePairs) throws MojoExecutionException {
        if (logger.isInfoEnabled()) {
            List argsWithSensitiveArgsMasked = argAndIsSensitivePairs.stream().map(pair -> (Boolean)pair.getRight() != false ? "XXXX" : (String)pair.getLeft()).collect(Collectors.toList());
            logger.info("Executing Docker command: {} {}", (Object)DOCKER_COMMAND, (Object)StringUtils.join(argsWithSensitiveArgsMasked, (String)" "));
        }
        ProcessExecutor executor = this.createDockerExecutor(argAndIsSensitivePairs.stream().map(Pair::getLeft).collect(Collectors.toList()));
        return executor.executeAndRedirectOutput(logger);
    }

    public int executeAndLogOutput(List<String> arguments) throws MojoExecutionException {
        if (logger.isInfoEnabled()) {
            logger.info("Executing Docker command: {} {}", (Object)DOCKER_COMMAND, (Object)StringUtils.join(arguments, (String)" "));
        }
        ProcessExecutor executor = this.createDockerExecutor(arguments);
        return executor.executeAndRedirectOutput(logger);
    }

    protected ProcessExecutor createDockerExecutor(List<String> arguments) {
        ArrayList<String> fullCommandArgs = new ArrayList<String>();
        fullCommandArgs.add(DOCKER_COMMAND);
        fullCommandArgs.addAll(arguments);
        return new ProcessExecutor(this.workingDirectory, fullCommandArgs, Platform.guess(), null);
    }
}

