/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.orphedomos.util.exec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.technologybrewery.orphedomos.util.OrphedomosException;
import org.technologybrewery.orphedomos.util.exec.Platform;

public class ProcessExecutor {
    private static final String PATH_ENV_VAR = "PATH";
    private Map<String, String> environment;
    private CommandLine commandLine;
    private Executor executor;

    public ProcessExecutor(File workingDirectory, List<String> command, Platform platform, Map<String, String> additionalEnvironment) {
        this(workingDirectory, new ArrayList<String>(), command, platform, additionalEnvironment, 0L);
    }

    public ProcessExecutor(File workingDirectory, List<String> paths, List<String> command, Platform platform, Map<String, String> additionalEnvironment) {
        this(workingDirectory, paths, command, platform, additionalEnvironment, 0L);
    }

    public ProcessExecutor(File workingDirectory, List<String> paths, List<String> command, Platform platform, Map<String, String> additionalEnvironment, long timeoutInSeconds) {
        this.environment = this.createEnvironment(paths, platform, additionalEnvironment);
        this.commandLine = this.createCommandLine(command);
        this.executor = this.createExecutor(workingDirectory, timeoutInSeconds);
    }

    public String executeAndGetResult(Logger logger) {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        DataRetentionLoggerOutputStream stderr = new DataRetentionLoggerOutputStream(logger, 0);
        int exitValue = -1;
        try {
            exitValue = this.execute(logger, stdout, (OutputStream)((Object)stderr));
        }
        catch (Exception e) {
            this.displayProcessOutputForException(stdout, logger);
            throw new OrphedomosException("Could not invoke command! See output above.", e);
        }
        if (exitValue == 0) {
            return ((Object)((Object)stderr)).toString().trim();
        }
        throw new OrphedomosException(stdout + " " + (OutputStream)((Object)stderr));
    }

    public int executeAndRedirectOutput(Logger logger) {
        LoggerOutputStream stdout = new LoggerOutputStream(logger, 0);
        LoggerOutputStream stderr = new LoggerOutputStream(logger, 0);
        try {
            int n = this.execute(logger, (OutputStream)((Object)stdout), (OutputStream)((Object)stderr));
            return n;
        }
        catch (Exception e) {
            throw new OrphedomosException("Could not invoke command! See output above.", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)((Object)stdout));
            IOUtils.closeQuietly((OutputStream)((Object)stderr));
        }
    }

    private int execute(Logger logger, OutputStream stdout, OutputStream stderr) {
        logger.debug("Executing command line {}", (Object)this.commandLine);
        try {
            PumpStreamHandler streamHandler = new PumpStreamHandler(stdout, stderr);
            this.executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            int exitValue = this.executor.execute(this.commandLine, this.environment);
            logger.debug("Exit value {}", (Object)exitValue);
            return exitValue;
        }
        catch (ExecuteException e) {
            if (this.executor.getWatchdog() != null && this.executor.getWatchdog().killedProcess()) {
                throw new OrphedomosException("Process killed after timeout");
            }
            if (ArrayUtils.contains((Object[])this.commandLine.getArguments(), (Object)"scan") && !ArrayUtils.contains((Object[])this.commandLine.getArguments(), (Object)"--version") && e.getExitValue() == 1) {
                return 1;
            }
            throw new OrphedomosException(e);
        }
        catch (IOException e) {
            throw new OrphedomosException(e);
        }
    }

    private CommandLine createCommandLine(List<String> command) {
        CommandLine commmandLine = new CommandLine(command.get(0));
        for (int i = 1; i < command.size(); ++i) {
            String argument = command.get(i);
            commmandLine.addArgument(argument, false);
        }
        return commmandLine;
    }

    private Map<String, String> createEnvironment(List<String> paths, Platform platform, Map<String, String> additionalEnvironment) {
        HashMap<String, String> localEnvironment = new HashMap<String, String>(System.getenv());
        if (additionalEnvironment != null) {
            localEnvironment.putAll(additionalEnvironment);
        }
        if (platform.isWindows()) {
            for (Map.Entry entry : localEnvironment.entrySet()) {
                String pathName = (String)entry.getKey();
                if (!PATH_ENV_VAR.equalsIgnoreCase(pathName)) continue;
                String pathValue = (String)entry.getValue();
                localEnvironment.put(pathName, this.extendPathVariable(pathValue, paths));
            }
        } else {
            String pathValue = (String)localEnvironment.get(PATH_ENV_VAR);
            localEnvironment.put(PATH_ENV_VAR, this.extendPathVariable(pathValue, paths));
        }
        return localEnvironment;
    }

    private String extendPathVariable(String existingValue, List<String> paths) {
        StringBuilder pathBuilder = new StringBuilder();
        for (String path : paths) {
            pathBuilder.append(path).append(File.pathSeparator);
        }
        if (existingValue != null) {
            pathBuilder.append(existingValue).append(File.pathSeparator);
        }
        return pathBuilder.toString();
    }

    private Executor createExecutor(File workingDirectory, long timeoutInSeconds) {
        DefaultExecutor localExecutor = new DefaultExecutor();
        localExecutor.setWorkingDirectory(workingDirectory);
        localExecutor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        if (timeoutInSeconds > 0L) {
            localExecutor.setWatchdog(new ExecuteWatchdog(timeoutInSeconds * 1000L));
        }
        return localExecutor;
    }

    protected void displayProcessOutputForException(ByteArrayOutputStream output, Logger logger) {
        String outputAsStr = output.toString();
        if (StringUtils.isNotBlank((CharSequence)outputAsStr)) {
            logger.error(outputAsStr);
        }
    }

    private static class DataRetentionLoggerOutputStream
    extends LoggerOutputStream {
        private String data = "";

        DataRetentionLoggerOutputStream(Logger logger, int logLevel) {
            super(logger, logLevel);
        }

        @Override
        protected void processLine(String line, int logLevel) {
            super.processLine(line, logLevel);
            this.data = this.data + line + "\r\n";
        }

        public String toString() {
            return this.data.trim();
        }
    }

    private static class LoggerOutputStream
    extends LogOutputStream {
        private final Logger logger;

        LoggerOutputStream(Logger logger, int logLevel) {
            super(logLevel);
            this.logger = logger;
        }

        public final void flush() {
        }

        protected void processLine(String line, int logLevel) {
            this.logger.info(line);
        }
    }
}

