/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.couchbase;

import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import java.util.concurrent.TimeUnit;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.teiid.core.BundleUtil;
import org.teiid.resource.adapter.couchbase.CouchbaseConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class CouchbaseManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = 8822399069779170119L;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(CouchbaseManagedConnectionFactory.class);
    private Long managementTimeout = TimeUnit.SECONDS.toMillis(75L);
    private Long queryTimeout = TimeUnit.SECONDS.toMillis(75L);
    private Long viewTimeout = TimeUnit.SECONDS.toMillis(75L);
    private Long kvTimeout = 2500L;
    private Long searchTimeout = TimeUnit.SECONDS.toMillis(75L);
    private Long connectTimeout = TimeUnit.SECONDS.toMillis(5L);
    private String scanConsistency = ScanConsistency.NOT_BOUNDED.name();
    private Boolean dnsSrvEnabled = false;
    private String connectionString = null;
    private String keyspace = null;
    private String namespace = null;
    private String password = null;
    private String timeUnit = null;

    public Long getManagementTimeout() {
        return this.managementTimeout;
    }

    public void setManagementTimeout(Long managementTimeout) {
        this.managementTimeout = managementTimeout;
    }

    public Long getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(Long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public Long getViewTimeout() {
        return this.viewTimeout;
    }

    public void setViewTimeout(Long viewTimeout) {
        this.viewTimeout = viewTimeout;
    }

    public Long getKvTimeout() {
        return this.kvTimeout;
    }

    public void setKvTimeout(Long kvTimeout) {
        this.kvTimeout = kvTimeout;
    }

    public Long getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setSearchTimeout(Long searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Boolean getDnsSrvEnabled() {
        return this.dnsSrvEnabled;
    }

    public void setDnsSrvEnabled(Boolean dnsSrvEnabled) {
        this.dnsSrvEnabled = dnsSrvEnabled;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getScanConsistency() {
        return this.scanConsistency;
    }

    public void setScanConsistency(String scanConsistency) {
        this.scanConsistency = scanConsistency;
    }

    public BasicConnectionFactory<CouchbaseConnectionImpl> createConnectionFactory() throws ResourceException {
        DefaultCouchbaseEnvironment environment = DefaultCouchbaseEnvironment.builder().managementTimeout(this.managementTimeout.longValue()).queryTimeout(this.queryTimeout.longValue()).viewTimeout(this.viewTimeout.longValue()).kvTimeout(this.kvTimeout.longValue()).searchTimeout(this.searchTimeout.longValue()).connectTimeout(this.connectTimeout.longValue()).dnsSrvEnabled(this.dnsSrvEnabled.booleanValue()).build();
        if (this.connectionString == null) {
            throw new InvalidPropertyException(UTIL.getString("no_server"));
        }
        if (this.keyspace == null) {
            throw new InvalidPropertyException(UTIL.getString("no_keyspace"));
        }
        if (this.namespace == null) {
            throw new InvalidPropertyException(UTIL.getString("no_namespace"));
        }
        ScanConsistency consistency = ScanConsistency.valueOf((String)this.scanConsistency);
        TimeUnit unit = TimeUnit.MILLISECONDS;
        if (this.timeUnit != null) {
            try {
                unit = TimeUnit.valueOf(this.timeUnit);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidPropertyException(UTIL.getString("invalid_timeUnit", new Object[]{this.timeUnit}));
            }
        }
        TimeUnit timeoutUnit = unit;
        return new BasicConnectionFactory<CouchbaseConnectionImpl>((CouchbaseEnvironment)environment, timeoutUnit, consistency){
            final /* synthetic */ CouchbaseEnvironment val$environment;
            final /* synthetic */ TimeUnit val$timeoutUnit;
            final /* synthetic */ ScanConsistency val$consistency;
            {
                this.val$environment = couchbaseEnvironment;
                this.val$timeoutUnit = timeUnit;
                this.val$consistency = scanConsistency;
            }

            public CouchbaseConnectionImpl getConnection() throws ResourceException {
                return new CouchbaseConnectionImpl(this.val$environment, CouchbaseManagedConnectionFactory.this.connectionString, CouchbaseManagedConnectionFactory.this.keyspace, CouchbaseManagedConnectionFactory.this.password, this.val$timeoutUnit, CouchbaseManagedConnectionFactory.this.namespace, this.val$consistency);
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getManagementTimeout().hashCode();
        result = 31 * result + this.getConnectTimeout().hashCode();
        result = 31 * result + this.getQueryTimeout().hashCode();
        result = 31 * result + this.getViewTimeout().hashCode();
        result = 31 * result + this.getKvTimeout().hashCode();
        result = 31 * result + this.getSearchTimeout().hashCode();
        result = 31 * result + this.getDnsSrvEnabled().hashCode();
        result = 31 * result + this.getConnectionString().hashCode();
        result = 31 * result + (this.keyspace == null ? 0 : this.getKeyspace().hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.getNamespace().hashCode());
        result = 31 * result + (this.password == null ? 0 : this.getPassword().hashCode());
        result = 31 * result + (this.timeUnit == null ? 0 : this.getTimeUnit().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CouchbaseManagedConnectionFactory other = (CouchbaseManagedConnectionFactory)((Object)obj);
        if (this.managementTimeout != other.managementTimeout) {
            return false;
        }
        if (this.queryTimeout != other.queryTimeout) {
            return false;
        }
        if (this.viewTimeout != other.viewTimeout) {
            return false;
        }
        if (this.kvTimeout != other.kvTimeout) {
            return false;
        }
        if (this.searchTimeout != other.searchTimeout) {
            return false;
        }
        if (this.connectTimeout != other.connectTimeout) {
            return false;
        }
        if (!this.dnsSrvEnabled.equals(other.dnsSrvEnabled)) {
            return false;
        }
        if (!CouchbaseManagedConnectionFactory.checkEquals((Object)this.connectionString, (Object)other.connectionString)) {
            return false;
        }
        if (!CouchbaseManagedConnectionFactory.checkEquals((Object)this.keyspace, (Object)other.keyspace)) {
            return false;
        }
        if (!CouchbaseManagedConnectionFactory.checkEquals((Object)this.namespace, (Object)other.namespace)) {
            return false;
        }
        if (!CouchbaseManagedConnectionFactory.checkEquals((Object)this.password, (Object)other.password)) {
            return false;
        }
        return CouchbaseManagedConnectionFactory.checkEquals((Object)this.timeUnit, (Object)other.timeUnit);
    }
}

