/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.couchbase;

import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import java.util.concurrent.TimeUnit;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.teiid.core.BundleUtil;
import org.teiid.resource.adapter.couchbase.CouchbaseConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class CouchbaseManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = 8822399069779170119L;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(CouchbaseManagedConnectionFactory.class);
    private Long managementTimeout = TimeUnit.SECONDS.toMillis(75L);
    private Long queryTimeout = TimeUnit.SECONDS.toMillis(75L);
    private Long viewTimeout = TimeUnit.SECONDS.toMillis(75L);
    private Long kvTimeout = 2500L;
    private Long searchTimeout = TimeUnit.SECONDS.toMillis(75L);
    private Long connectTimeout = TimeUnit.SECONDS.toMillis(5L);
    private String scanConsistency = ScanConsistency.NOT_BOUNDED.name();
    private Boolean dnsSrvEnabled = false;
    private String connectionString = null;
    private String keyspace = null;
    private String namespace = null;
    private String password = null;
    private String timeUnit = null;

    public Long getManagementTimeout() {
        return this.managementTimeout;
    }

    public void setManagementTimeout(Long managementTimeout) {
        this.managementTimeout = managementTimeout;
    }

    public Long getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(Long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public Long getViewTimeout() {
        return this.viewTimeout;
    }

    public void setViewTimeout(Long viewTimeout) {
        this.viewTimeout = viewTimeout;
    }

    public Long getKvTimeout() {
        return this.kvTimeout;
    }

    public void setKvTimeout(Long kvTimeout) {
        this.kvTimeout = kvTimeout;
    }

    public Long getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setSearchTimeout(Long searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Boolean getDnsSrvEnabled() {
        return this.dnsSrvEnabled;
    }

    public void setDnsSrvEnabled(Boolean dnsSrvEnabled) {
        this.dnsSrvEnabled = dnsSrvEnabled;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getScanConsistency() {
        return this.scanConsistency;
    }

    public void setScanConsistency(String scanConsistency) {
        this.scanConsistency = scanConsistency;
    }

    public BasicConnectionFactory<CouchbaseConnectionImpl> createConnectionFactory() throws ResourceException {
        DefaultCouchbaseEnvironment environment = DefaultCouchbaseEnvironment.builder().managementTimeout(this.managementTimeout.longValue()).queryTimeout(this.queryTimeout.longValue()).viewTimeout(this.viewTimeout.longValue()).kvTimeout(this.kvTimeout.longValue()).searchTimeout(this.searchTimeout.longValue()).connectTimeout(this.connectTimeout.longValue()).dnsSrvEnabled(this.dnsSrvEnabled.booleanValue()).build();
        if (this.connectionString == null) {
            throw new InvalidPropertyException(UTIL.getString("no_server"));
        }
        if (this.keyspace == null) {
            throw new InvalidPropertyException(UTIL.getString("no_keyspace"));
        }
        if (this.namespace == null) {
            throw new InvalidPropertyException(UTIL.getString("no_namespace"));
        }
        ScanConsistency consistency = ScanConsistency.valueOf((String)this.scanConsistency);
        TimeUnit unit = TimeUnit.MILLISECONDS;
        if (this.timeUnit != null) {
            try {
                unit = TimeUnit.valueOf(this.timeUnit);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidPropertyException(UTIL.getString("invalid_timeUnit", new Object[]{this.timeUnit}));
            }
        }
        TimeUnit timeoutUnit = unit;
        return new BasicConnectionFactory<CouchbaseConnectionImpl>((CouchbaseEnvironment)environment, timeoutUnit, consistency){
            final /* synthetic */ CouchbaseEnvironment val$environment;
            final /* synthetic */ TimeUnit val$timeoutUnit;
            final /* synthetic */ ScanConsistency val$consistency;
            {
                this.val$environment = couchbaseEnvironment;
                this.val$timeoutUnit = timeUnit;
                this.val$consistency = scanConsistency;
            }

            public CouchbaseConnectionImpl getConnection() throws ResourceException {
                return new CouchbaseConnectionImpl(this.val$environment, CouchbaseManagedConnectionFactory.this.connectionString, CouchbaseManagedConnectionFactory.this.keyspace, CouchbaseManagedConnectionFactory.this.password, this.val$timeoutUnit, CouchbaseManagedConnectionFactory.this.namespace, this.val$consistency);
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connectTimeout == null ? 0 : this.connectTimeout.hashCode());
        result = 31 * result + (this.connectionString == null ? 0 : this.connectionString.hashCode());
        result = 31 * result + (this.dnsSrvEnabled == null ? 0 : this.dnsSrvEnabled.hashCode());
        result = 31 * result + (this.keyspace == null ? 0 : this.keyspace.hashCode());
        result = 31 * result + (this.kvTimeout == null ? 0 : this.kvTimeout.hashCode());
        result = 31 * result + (this.managementTimeout == null ? 0 : this.managementTimeout.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.queryTimeout == null ? 0 : this.queryTimeout.hashCode());
        result = 31 * result + (this.scanConsistency == null ? 0 : this.scanConsistency.hashCode());
        result = 31 * result + (this.searchTimeout == null ? 0 : this.searchTimeout.hashCode());
        result = 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode());
        result = 31 * result + (this.viewTimeout == null ? 0 : this.viewTimeout.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CouchbaseManagedConnectionFactory other = (CouchbaseManagedConnectionFactory)((Object)obj);
        if (this.connectTimeout == null ? other.connectTimeout != null : !this.connectTimeout.equals(other.connectTimeout)) {
            return false;
        }
        if (this.connectionString == null ? other.connectionString != null : !this.connectionString.equals(other.connectionString)) {
            return false;
        }
        if (this.dnsSrvEnabled == null ? other.dnsSrvEnabled != null : !this.dnsSrvEnabled.equals(other.dnsSrvEnabled)) {
            return false;
        }
        if (this.keyspace == null ? other.keyspace != null : !this.keyspace.equals(other.keyspace)) {
            return false;
        }
        if (this.kvTimeout == null ? other.kvTimeout != null : !this.kvTimeout.equals(other.kvTimeout)) {
            return false;
        }
        if (this.managementTimeout == null ? other.managementTimeout != null : !this.managementTimeout.equals(other.managementTimeout)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.queryTimeout == null ? other.queryTimeout != null : !this.queryTimeout.equals(other.queryTimeout)) {
            return false;
        }
        if (this.scanConsistency == null ? other.scanConsistency != null : !this.scanConsistency.equals(other.scanConsistency)) {
            return false;
        }
        if (this.searchTimeout == null ? other.searchTimeout != null : !this.searchTimeout.equals(other.searchTimeout)) {
            return false;
        }
        if (this.timeUnit == null ? other.timeUnit != null : !this.timeUnit.equals(other.timeUnit)) {
            return false;
        }
        return !(this.viewTimeout == null ? other.viewTimeout != null : !this.viewTimeout.equals(other.viewTimeout));
    }
}

