/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import java.util.concurrent.TimeUnit;
import javax.resource.ResourceException;
import org.teiid.core.BundleUtil;
import org.teiid.couchbase.CouchbaseConnection;
import org.teiid.resource.spi.BasicConnection;

public class CouchbaseConnectionImpl
extends BasicConnection
implements CouchbaseConnection {
    static final BundleUtil UTIL = BundleUtil.getBundleUtil(CouchbaseConnectionImpl.class);
    private Cluster cluster;
    private Bucket bucket;
    private String namespace;
    private ScanConsistency scanConsistency;

    public CouchbaseConnectionImpl(CouchbaseEnvironment environment, String connectionString, String keyspace, String password, TimeUnit timeUnit, String namespace, ScanConsistency scanConsistent) {
        this.scanConsistency = scanConsistent;
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)environment, (String[])new String[]{connectionString});
        this.bucket = password != null ? this.cluster.openBucket(keyspace, password, environment.connectTimeout(), timeUnit) : this.cluster.openBucket(keyspace, environment.connectTimeout(), timeUnit);
        this.namespace = namespace;
    }

    public N1qlQueryResult execute(String statement) throws ResourceException {
        N1qlQueryResult result = this.bucket.query((N1qlQuery)N1qlQuery.simple((String)statement, (N1qlParams)N1qlParams.build().consistency(this.scanConsistency)));
        if (!result.finalSuccess()) {
            throw new ResourceException(UTIL.gs("query_error", new Object[]{result.errors()}), result.status());
        }
        return result;
    }

    public void close() throws ResourceException {
        if (this.bucket != null) {
            this.bucket.close();
        }
        this.cluster.disconnect();
    }

    public String getNamespace() {
        return this.namespace;
    }
}

