/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ftp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.resource.ResourceException;
import org.apache.commons.net.ftp.FTPClient;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.resource.adapter.ftp.FtpFileSystem;
import org.teiid.resource.adapter.ftp.FtpManagedConnectionFactory;

@Ignore(value="Ignore due to this test depend on remote ftp server and reference configuration")
public class TestFtpFileSystem {
    @BeforeClass
    public static void sample() throws IOException, ResourceException {
        FtpManagedConnectionFactory mcf = new FtpManagedConnectionFactory();
        mcf.setParentDirectory("/home/kylin/vsftpd");
        mcf.setHost("10.66.192.120");
        mcf.setPort(Integer.valueOf(21));
        mcf.setUsername("kylin");
        mcf.setPassword("redhat");
        VirtualFile mountPoint = VFS.getChild((String)"/home/kylin/vsftpd");
        VFS.mount((VirtualFile)mountPoint, (FileSystem)new FtpFileSystem(mcf.createClient()));
    }

    @Test
    public void testGetFile() throws IOException, ResourceException {
        File file = VFS.getChild((String)"/home/kylin/vsftpd/not-exist.txt").getPhysicalFile();
        Assert.assertNull((Object)file);
    }

    @Test
    public void testOpenStream() throws IOException, ResourceException {
        InputStream in = VFS.getChild((String)"/home/kylin/vsftpd/not-exist.txt").openStream();
        Assert.assertNull((Object)in);
        in = VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").openStream();
        Assert.assertNotNull((Object)in);
        in.close();
    }

    @Test
    public void testDelete() throws IOException, ResourceException {
        this.writeFile(new File("pom.xml").getAbsolutePath());
        VirtualFile file = VFS.getChild((String)"/home/kylin/vsftpd/pom.xml");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.delete());
        Assert.assertFalse((boolean)file.exists());
    }

    private void writeFile(String path) throws ResourceException, IOException {
        VirtualFile file = VFS.getChild((String)path);
        FtpManagedConnectionFactory mcf = new FtpManagedConnectionFactory();
        mcf.setParentDirectory("/home/kylin/vsftpd");
        mcf.setHost("10.66.192.120");
        mcf.setPort(Integer.valueOf(21));
        mcf.setUsername("kylin");
        mcf.setPassword("redhat");
        FTPClient client = mcf.createClient();
        client.storeFile(file.getName(), file.openStream());
        client.disconnect();
    }

    @Test
    public void testGetSize() {
        Assert.assertEquals((long)-1L, (long)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").getSize());
        Assert.assertEquals((long)-1L, (long)VFS.getChild((String)"/home/kylin/vsftpd/sub").getSize());
    }

    @Test
    public void testGetLastModified() {
        Assert.assertEquals((long)1480314470000L, (long)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").getLastModified());
        Assert.assertEquals((long)-1L, (long)VFS.getChild((String)"/home/kylin/vsftpd/sub").getLastModified());
    }

    @Test
    public void testExists() {
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").exists());
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price1.txt").exists());
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/sub").exists());
    }

    @Test
    public void testIsFile() {
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").isFile());
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price1.txt").isFile());
        Assert.assertFalse((boolean)VFS.getChild((String)"/home/kylin/vsftpd/sub").isFile());
    }

    @Test
    public void testIsDirectory() {
        Assert.assertFalse((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").isDirectory());
        Assert.assertFalse((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price1.txt").isDirectory());
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/sub").isDirectory());
    }

    @Test
    public void testNamelist() {
        Assert.assertTrue((VFS.getChild((String)"/home/kylin/vsftpd").getChildren().size() > 0 ? 1 : 0) != 0);
    }
}

