/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ftp;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import javax.resource.ResourceException;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.file.VirtualFileConnection;
import org.teiid.resource.adapter.ftp.FtpManagedConnectionFactory;

@Ignore(value="Ignore due to this test depend on remote ftp server and reference configuration")
public class TestFtpFileConnection {
    private static VirtualFileConnection sample() throws ResourceException {
        FtpManagedConnectionFactory mcf = new FtpManagedConnectionFactory();
        mcf.setParentDirectory("/home/kylin/vsftpd");
        mcf.setHost("10.66.192.120");
        mcf.setPort(Integer.valueOf(21));
        mcf.setUsername("kylin");
        mcf.setPassword("redhat");
        return (VirtualFileConnection)mcf.createConnectionFactory().getConnection();
    }

    @Test
    public void testGetFile() throws ResourceException, IOException {
        VirtualFileConnection conn = TestFtpFileConnection.sample();
        VirtualFile file = conn.getFile("marketdata-price.txt");
        Assert.assertNotNull((Object)file.openStream());
        file = conn.getFile("marketdata-price1.txt");
        Assert.assertNotNull((Object)file.openStream());
        conn.close();
    }

    @Test
    public void testPatternFilter() {
        String[] array;
        String fileName = "*.txt";
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:*" + fileName);
        for (String name : array = new String[]{"/path/to/marketdata-price.txt", "marketdata-price1.txt"}) {
            Assert.assertTrue((boolean)matcher.matches(Paths.get(name, new String[0])));
        }
    }

    @Test(expected=ResourceException.class)
    public void testGetFiles() throws ResourceException, IOException {
        VirtualFileConnection conn = TestFtpFileConnection.sample();
        VirtualFile[] files = conn.getFiles("*.txt");
        Assert.assertEquals((long)2L, (long)files.length);
        conn.close();
    }

    @Test
    public void testAdd() throws IOException, ResourceException {
        VirtualFileConnection conn = TestFtpFileConnection.sample();
        VirtualFile file = conn.getFile("pom.xml");
        Assert.assertFalse((boolean)file.exists());
        VirtualFile pom = VFS.getChild((String)new File("pom.xml").getAbsolutePath());
        conn.add(pom.openStream(), pom);
        Assert.assertTrue((boolean)file.exists());
        conn.close();
        conn = TestFtpFileConnection.sample();
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertNotNull((Object)file.openStream());
        conn.close();
    }

    @Test
    public void testRemove() throws ResourceException, IOException {
        VirtualFileConnection conn = TestFtpFileConnection.sample();
        VirtualFile pom = VFS.getChild((String)new File("pom.xml").getAbsolutePath());
        VirtualFile file = conn.getFile("pom.xml");
        conn.add(pom.openStream(), pom);
        Assert.assertTrue((boolean)file.exists());
        conn.remove("pom.xml");
        Assert.assertFalse((boolean)file.exists());
        conn.close();
    }
}

