/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ftp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.apache.commons.net.ftp.FTPClient;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;
import org.teiid.core.BundleUtil;
import org.teiid.file.VirtualFileConnection;
import org.teiid.resource.adapter.ftp.FtpFileSystem;
import org.teiid.resource.spi.BasicConnection;

public class FtpFileConnectionImpl
extends BasicConnection
implements VirtualFileConnection {
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(FtpFileConnectionImpl.class);
    private VirtualFile mountPoint;
    private Map<String, String> fileMapping;
    private Closeable closeable;
    private final FTPClient client;

    public FtpFileConnectionImpl(FTPClient client, String pathname, Map<String, String> fileMapping) throws ResourceException {
        this.client = client;
        this.fileMapping = fileMapping == null ? Collections.emptyMap() : fileMapping;
        try {
            if (this.client.cwd(pathname) != 250) {
                throw new InvalidPropertyException(UTIL.getString("parentdirectory_not_set"));
            }
            this.client.changeWorkingDirectory(pathname);
            this.mountPoint = VFS.getChild((String)pathname);
            this.closeable = VFS.mount((VirtualFile)this.mountPoint, (FileSystem)new FtpFileSystem(this.client));
        }
        catch (IOException e) {
            throw new ResourceException(UTIL.getString("vfs_mount_error", new Object[]{pathname}), (Throwable)e);
        }
    }

    public void close() throws ResourceException {
        try {
            this.closeable.close();
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public VirtualFile[] getFiles(String pattern) throws ResourceException {
        if (this.getFile(pattern).exists()) {
            return new VirtualFile[]{this.getFile(pattern)};
        }
        throw new ResourceException("Can not open multiple ftp stream based file in one connection");
    }

    public VirtualFile getFile(String path) throws ResourceException {
        if (path == null) {
            return this.mountPoint;
        }
        String altPath = this.fileMapping.get(path);
        if (altPath != null) {
            path = altPath;
        }
        return this.mountPoint.getChild(path);
    }

    public boolean add(InputStream in, VirtualFile file) throws ResourceException {
        try {
            return this.client.storeFile(file.getName(), in);
        }
        catch (IOException e) {
            throw new ResourceException(UTIL.getString("ftp_failed_write", new Object[]{file.getName(), this.client.getReplyString()}), (Throwable)e);
        }
    }

    public boolean remove(String path) throws ResourceException {
        return this.mountPoint.getChild(path).delete();
    }
}

