/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.dataprotocol;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.google.auth.AuthHeaderFactory;
import org.teiid.resource.adapter.google.dataprotocol.GoogleJSONParser;
import org.teiid.translator.google.api.SpreadsheetAuthException;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.Column;
import org.teiid.translator.google.api.metadata.SpreadsheetColumnType;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.result.PartialResultExecutor;
import org.teiid.translator.google.api.result.RowsResult;
import org.teiid.translator.google.api.result.SheetRow;

public class GoogleDataProtocolAPI {
    private AuthHeaderFactory headerFactory = null;
    public static String ENCODING = "UTF-8";
    private GoogleJSONParser parser = new GoogleJSONParser();

    public AuthHeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public void setHeaderFactory(AuthHeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
    }

    public RowsResult executeQuery(SpreadsheetInfo info, String worksheetTitle, String query, int batchSize, Integer offset, Integer limit) {
        String key = info.getSpreadsheetKey();
        RowsResult result = new RowsResult((PartialResultExecutor)new DataProtocolQueryStrategy(key, worksheetTitle, query), batchSize);
        if (offset != null) {
            result.setOffset(offset.intValue());
        }
        if (limit != null) {
            result.setLimit(limit.intValue());
        }
        return result;
    }

    public List<Column> getMetadata(String key, String worksheetTitle) {
        DataProtocolQueryStrategy dpqs = new DataProtocolQueryStrategy(key, worksheetTitle, "SELECT *");
        dpqs.getResultsBatch(0, 1);
        return dpqs.getMetadata();
    }

    static Object convertValue(Calendar cal, Object object, SpreadsheetColumnType type) {
        switch (type) {
            case DATE: 
            case DATETIME: {
                String stringVal;
                if (!(object instanceof String) || !(stringVal = (String)object).startsWith("Date(") || !stringVal.endsWith(")")) break;
                String[] parts = stringVal.substring(5, stringVal.length() - 1).split(",");
                if (cal == null) {
                    cal = Calendar.getInstance();
                }
                cal.clear();
                if (type == SpreadsheetColumnType.DATETIME) {
                    cal.set(Integer.valueOf(parts[0]), Integer.valueOf(parts[1]), Integer.valueOf(parts[2]), Integer.valueOf(parts[3]), Integer.valueOf(parts[4]), Integer.valueOf(parts[5]));
                    object = new Timestamp(cal.getTimeInMillis());
                    break;
                }
                cal.set(Integer.valueOf(parts[0]), Integer.valueOf(parts[1]), Integer.valueOf(parts[2]));
                object = new Date(cal.getTimeInMillis());
                break;
            }
            case TIMEOFDAY: {
                if (!(object instanceof List)) break;
                List doubleVals = (List)object;
                if (cal == null) {
                    cal = Calendar.getInstance();
                }
                cal.clear();
                cal.set(1, 1970);
                cal.set(2, 0);
                cal.set(5, 1);
                cal.set(14, 0);
                cal.set(10, ((Double)doubleVals.get(0)).intValue());
                cal.set(12, ((Double)doubleVals.get(1)).intValue());
                cal.set(13, ((Double)doubleVals.get(2)).intValue());
                cal.set(14, ((Double)doubleVals.get(3)).intValue());
                object = new Time(cal.getTimeInMillis());
            }
        }
        return object;
    }

    public class DataProtocolQueryStrategy
    implements PartialResultExecutor {
        private String spreadsheetKey;
        private String worksheetName;
        private String urlEncodedQuery;
        private List<Column> metadata;

        public DataProtocolQueryStrategy(String key, String worksheetKey, String query) {
            this.spreadsheetKey = key;
            this.worksheetName = worksheetKey;
            try {
                this.urlEncodedQuery = URLEncoder.encode(query, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new SpreadsheetOperationException((Throwable)e);
            }
        }

        public List<Column> getMetadata() {
            return this.metadata;
        }

        public List<SheetRow> getResultsBatch(int startIndex, int amount) {
            String boundariedQuery = null;
            String worksheet = null;
            try {
                boundariedQuery = this.getQueryWithBoundaries(amount, Math.max(0, startIndex));
                worksheet = URLEncoder.encode(this.worksheetName, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new SpreadsheetOperationException((Throwable)e);
            }
            HttpGet get = new HttpGet("https://spreadsheets.google.com/tq?key=" + this.spreadsheetKey + "&sheet=" + worksheet + "&tqx=responseHandler:x;out:json&tq=" + boundariedQuery);
            get.setHeader("GData-Version", "3.0");
            get.setHeader("Authorization", GoogleDataProtocolAPI.this.headerFactory.getAuthHeader());
            try {
                DefaultHttpClient client = new DefaultHttpClient();
                try {
                    return this.executeAndParse((HttpClient)client, get);
                }
                catch (SpreadsheetAuthException e) {
                    GoogleDataProtocolAPI.this.headerFactory.login();
                    get.setHeader("Authorization", GoogleDataProtocolAPI.this.headerFactory.getAuthHeader());
                    return this.executeAndParse((HttpClient)client, get);
                }
            }
            catch (IOException e) {
                throw new SpreadsheetOperationException("Error retrieving batch from Gogole Visualization Data protocol", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<SheetRow> executeAndParse(HttpClient client, HttpGet get) throws IOException {
            HttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                Calendar cal = null;
                try (Reader reader = null;){
                    reader = new InputStreamReader(response.getEntity().getContent(), Charset.forName(ENCODING));
                    Map jsonResponse = (Map)GoogleDataProtocolAPI.this.parser.parseObject(reader, true);
                    String status = (String)jsonResponse.get("status");
                    if ("error".equals(status)) {
                        List errors = (List)jsonResponse.get("errors");
                        ArrayList<String> reasons = new ArrayList<String>();
                        for (Map map : errors) {
                            String reason = (String)map.get("reason");
                            if ("user_not_authenticated".equals(reason)) {
                                throw new SpreadsheetAuthException("User not authenticated");
                            }
                            reasons.add(reason);
                        }
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Google request failed", (Object)errors);
                        throw new SpreadsheetOperationException(((Object)reasons).toString());
                    }
                    Map table = (Map)jsonResponse.get("table");
                    List cols = (List)table.get("cols");
                    this.metadata = new ArrayList<Column>(cols.size());
                    for (Map col : cols) {
                        String type;
                        Column c = new Column();
                        c.setAlphaName((String)col.get("id"));
                        String label = (String)col.get("label");
                        if (label != null && !label.isEmpty()) {
                            c.setLabel(label);
                        }
                        if ((type = (String)col.get("type")) != null) {
                            c.setDataType(SpreadsheetColumnType.valueOf((String)type.toUpperCase()));
                        }
                        this.metadata.add(c);
                    }
                    ArrayList<SheetRow> result = new ArrayList<SheetRow>();
                    List rows = (List)table.get("rows");
                    for (Map row : rows) {
                        SheetRow returnRow = new SheetRow();
                        List vals = (List)row.get("c");
                        int i = -1;
                        for (Map val : vals) {
                            ++i;
                            if (val == null) {
                                returnRow.addColumn(null);
                                continue;
                            }
                            Object object = val.get("v");
                            if (object != null) {
                                Column c = this.metadata.get(i);
                                object = GoogleDataProtocolAPI.convertValue(cal, object, c.getDataType());
                            }
                            returnRow.addColumn(object);
                        }
                        result.add(returnRow);
                    }
                    ArrayList<SheetRow> arrayList = result;
                    return arrayList;
                }
            }
            if (response.getStatusLine().getStatusCode() == 500) {
                return new ArrayList<SheetRow>();
            }
            throw new SpreadsheetOperationException("Error when getting batch " + response.getStatusLine().getStatusCode() + ":" + response.getStatusLine().getReasonPhrase());
        }

        private String getQueryWithBoundaries(int amount, int offset) throws UnsupportedEncodingException {
            String[] keywordsToJump = new String[]{"label", "format", "options"};
            int indexToPut = this.urlEncodedQuery.length();
            for (String jumpIt : keywordsToJump) {
                int index = this.urlEncodedQuery.indexOf(jumpIt);
                if (index == -1) continue;
                indexToPut = index;
                break;
            }
            return this.urlEncodedQuery.substring(0, indexToPut).toString() + URLEncoder.encode(" limit " + amount + " offset " + offset + " ", ENCODING).toString() + this.urlEncodedQuery.substring(indexToPut).toString();
        }
    }
}

