/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.unit;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.resource.adapter.google.dataprotocol.GoogleJSONParser;

public class GoogleJSONParserTest {
    GoogleJSONParser parser = new GoogleJSONParser();

    @Test
    public void testDateParsing() throws Exception {
        Date date = (Date)this.parser.parseObject((Reader)new StringReader("new Date(2001,1,2)"), false);
        Assert.assertEquals((Object)TimestampUtil.createDate((int)101, (int)1, (int)2), (Object)date);
    }

    @Test
    public void testTimestampParsing() throws Exception {
        Timestamp ts = (Timestamp)this.parser.parseObject((Reader)new StringReader("new Date(2001,11,2,5,6,12,100)"), false);
        Assert.assertEquals((Object)TimestampUtil.createTimestamp((int)101, (int)11, (int)2, (int)5, (int)6, (int)12, (int)100000000), (Object)ts);
    }

    @Test
    public void testArray() throws Exception {
        List val = (List)this.parser.parseObject((Reader)new StringReader("['a','b','c']"), false);
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)val);
    }

    @Test
    public void testArrayNullValues() throws Exception {
        List val = (List)this.parser.parseObject((Reader)new StringReader("[,\"a\",]"), false);
        Assert.assertEquals(Arrays.asList(null, "a"), (Object)val);
    }

    @Test
    public void testWrapped() throws Exception {
        Map val = (Map)this.parser.parseObject((Reader)new StringReader("x({\"y\":100, \"z\" : null})"), true);
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        expected.put("y", 100.0);
        expected.put("z", null);
        Assert.assertEquals(expected, (Object)val);
    }

    @Test
    public void testStringEncoding() throws Exception {
        String val = (String)this.parser.parseObject((Reader)new StringReader("'\\u1234\\n\\t'"), false);
        Assert.assertEquals((Object)"\u1234\n\t", (Object)val);
    }
}

