/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.unit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.teiid.translator.google.api.result.PartialResultExecutor;
import org.teiid.translator.google.api.result.RowsResult;
import org.teiid.translator.google.api.result.SheetRow;

public class RowsResultTest {
    @Test
    public void simpleIteration() {
        final ArrayList<SheetRow> rows = new ArrayList<SheetRow>();
        rows.add(new SheetRow(new String[]{"a", "b", "c"}));
        rows.add(new SheetRow(new String[]{"a2", "b2", "c2"}));
        rows.add(new SheetRow(new String[]{"a3", "b3", "c3"}));
        RowsResult result = new RowsResult(new PartialResultExecutor(){
            boolean called = false;

            public List<SheetRow> getResultsBatch(int startIndex, int endIndex) {
                if (this.called) {
                    Assert.fail((String)"getResultsBatch should've been called only once");
                }
                this.called = true;
                return rows;
            }
        }, 10);
        int i = 0;
        for (SheetRow row : result) {
            Assert.assertEquals((Object)row, rows.get(i++));
        }
    }

    @Test
    public void twoBatchCallsNeeded() {
        final ArrayList<SheetRow> firstPart = new ArrayList<SheetRow>();
        final ArrayList<SheetRow> secondPart = new ArrayList<SheetRow>();
        ArrayList<SheetRow> all = new ArrayList<SheetRow>();
        firstPart.add(new SheetRow(new String[]{"a", "b", "c"}));
        firstPart.add(new SheetRow(new String[]{"a2", "b2", "c2"}));
        firstPart.add(new SheetRow(new String[]{"a3", "b3", "c3"}));
        secondPart.add(new SheetRow(new String[]{"a4", "b4", "c4"}));
        secondPart.add(new SheetRow(new String[]{"a5", "b5", "c5"}));
        all.addAll(firstPart);
        all.addAll(secondPart);
        RowsResult result = new RowsResult(new PartialResultExecutor(){
            int called = 0;

            public List<SheetRow> getResultsBatch(int startIndex, int endIndex) {
                if (this.called++ > 2) {
                    Assert.fail((String)"getResultsBatch at most twice");
                }
                if (this.called == 1) {
                    return firstPart;
                }
                if (this.called == 2) {
                    return secondPart;
                }
                return null;
            }
        }, 3);
        int i = 0;
        for (SheetRow row : result) {
            Assert.assertEquals((Object)row, all.get(i++));
        }
        Assert.assertEquals((String)"Six rows should be in the result", (int)5, (int)i);
    }

    @Test
    public void noRows() {
        final ArrayList all = new ArrayList();
        RowsResult result = new RowsResult(new PartialResultExecutor(){
            int called = 0;

            public List<SheetRow> getResultsBatch(int startIndex, int endIndex) {
                if (this.called++ > 1) {
                    Assert.fail((String)"getResultsBatch at once");
                }
                return all;
            }
        }, 3);
        int i = 0;
        for (SheetRow row : result) {
            ++i;
        }
        Assert.assertEquals((String)"No iterations should be made", (int)0, (int)i);
    }

    @Test
    public void sixBatchCalls() {
        final ArrayList<SheetRow> all = new ArrayList<SheetRow>();
        all.add(new SheetRow(new String[]{"a", "b", "c"}));
        all.add(new SheetRow(new String[]{"a2", "b2", "c2"}));
        all.add(new SheetRow(new String[]{"a3", "b3", "c3"}));
        all.add(new SheetRow(new String[]{"a4", "b4", "c4"}));
        all.add(new SheetRow(new String[]{"a5", "b5", "c5"}));
        all.add(new SheetRow(new String[]{"a6", "b6", "c6"}));
        RowsResult result = new RowsResult(new PartialResultExecutor(){
            int called = 0;

            public List<SheetRow> getResultsBatch(int startIndex, int endIndex) {
                if (this.called > 6) {
                    Assert.fail((String)"getResultsBatch at least 6 times");
                }
                if (this.called == 6) {
                    return new ArrayList<SheetRow>();
                }
                return Collections.singletonList(all.get(this.called++));
            }
        }, 1);
        int i = 0;
        for (SheetRow row : result) {
            Assert.assertEquals(all.get(i++), (Object)row);
        }
        Assert.assertEquals((String)"Six iterations should be made", (int)6, (int)i);
    }

    @Test
    public void offsetTest() {
        final ArrayList<SheetRow> all = new ArrayList<SheetRow>();
        all.add(new SheetRow(new String[]{"a", "b", "c"}));
        all.add(new SheetRow(new String[]{"a2", "b2", "c2"}));
        all.add(new SheetRow(new String[]{"a3", "b3", "c3"}));
        all.add(new SheetRow(new String[]{"a4", "b4", "c4"}));
        all.add(new SheetRow(new String[]{"a5", "b5", "c5"}));
        all.add(new SheetRow(new String[]{"a6", "b6", "c6"}));
        RowsResult result = new RowsResult(new PartialResultExecutor(){
            int called = 0;

            public List<SheetRow> getResultsBatch(int startIndex, int endIndex) {
                if (this.called++ > 1) {
                    Assert.fail((String)"getResultsBatch at most 2 times");
                }
                ArrayList<SheetRow> result = new ArrayList<SheetRow>();
                if (this.called == 1) {
                    result.add((SheetRow)all.get(3));
                    result.add((SheetRow)all.get(4));
                } else if (this.called == 2) {
                    result.add((SheetRow)all.get(5));
                }
                return result;
            }
        }, 2);
        result.setOffset(3);
        result.setLimit(3);
        int i = 3;
        for (SheetRow row : result) {
            Assert.assertEquals(all.get(i++), (Object)row);
        }
        Assert.assertEquals((String)"3 iterations should be made", (int)3, (int)(i - 3));
    }

    @Test
    public void offsetTestOne() {
        final ArrayList<SheetRow> all = new ArrayList<SheetRow>();
        all.add(new SheetRow(new String[]{"a", "b", "c"}));
        all.add(new SheetRow(new String[]{"a2", "b2", "c2"}));
        all.add(new SheetRow(new String[]{"a3", "b3", "c3"}));
        all.add(new SheetRow(new String[]{"a4", "b4", "c4"}));
        all.add(new SheetRow(new String[]{"a5", "b5", "c5"}));
        all.add(new SheetRow(new String[]{"a6", "b6", "c6"}));
        RowsResult result = new RowsResult(new PartialResultExecutor(){
            int called = 0;

            public List<SheetRow> getResultsBatch(int startIndex, int endIndex) {
                if (this.called++ > 2) {
                    Assert.fail((String)"getResultsBatch at most 3 times");
                }
                ArrayList<SheetRow> result = new ArrayList<SheetRow>();
                if (this.called == 1) {
                    result.add((SheetRow)all.get(1));
                    result.add((SheetRow)all.get(2));
                } else if (this.called == 2) {
                    result.add((SheetRow)all.get(3));
                    result.add((SheetRow)all.get(4));
                } else if (this.called == 3) {
                    result.add((SheetRow)all.get(5));
                }
                return result;
            }
        }, 2);
        result.setOffset(1);
        result.setLimit(6);
        int i = 1;
        for (SheetRow row : result) {
            Assert.assertEquals(all.get(i++), (Object)row);
        }
        Assert.assertEquals((String)"5 iterations should be made", (int)5, (int)(i - 1));
    }
}

