/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.google.SpreadsheetManagedConnectionFactory;
import org.teiid.resource.adapter.google.auth.OAuth2HeaderFactory;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.resource.adapter.google.gdata.GDataClientLoginAPI;
import org.teiid.resource.adapter.google.gdata.SpreadsheetMetadataExtractor;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;
import org.teiid.translator.google.api.UpdateSet;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Worksheet;
import org.teiid.translator.google.api.result.RowsResult;
import org.teiid.translator.google.api.result.UpdateResult;

public class SpreadsheetConnectionImpl
extends BasicConnection
implements GoogleSpreadsheetConnection {
    private SpreadsheetManagedConnectionFactory config;
    private GDataClientLoginAPI gdata = null;
    private GoogleDataProtocolAPI dataProtocol = null;
    private AtomicReference<SpreadsheetInfo> spreadsheetInfo;

    public SpreadsheetConnectionImpl(SpreadsheetManagedConnectionFactory config, AtomicReference<SpreadsheetInfo> spreadsheetInfo) {
        this.config = config;
        this.spreadsheetInfo = spreadsheetInfo;
        OAuth2HeaderFactory authHeaderFactory = new OAuth2HeaderFactory(config.getRefreshToken().trim());
        if (config.getClientId() != null) {
            authHeaderFactory.setClientId(config.getClientId());
            authHeaderFactory.setClientSecret(config.getClientSecret());
        }
        this.gdata = new GDataClientLoginAPI();
        this.dataProtocol = new GoogleDataProtocolAPI();
        authHeaderFactory.login();
        this.dataProtocol.setHeaderFactory(authHeaderFactory);
        this.gdata.setHeaderFactory(authHeaderFactory);
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SpreadsheetManagedConnectionFactory.UTIL.getString("init"));
    }

    public void close() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SpreadsheetManagedConnectionFactory.UTIL.getString("closing"));
    }

    public boolean isAlive() {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)SpreadsheetManagedConnectionFactory.UTIL.getString("alive"));
        return true;
    }

    public RowsResult executeQuery(String worksheetTitle, String query, Integer offset, Integer limit, int batchSize) {
        return this.dataProtocol.executeQuery(this.getSpreadsheetInfo(), worksheetTitle, query, Math.min(batchSize, this.config.getBatchSize()), offset, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpreadsheetInfo getSpreadsheetInfo() {
        SpreadsheetInfo info = this.spreadsheetInfo.get();
        if (info == null) {
            AtomicReference<SpreadsheetInfo> atomicReference = this.spreadsheetInfo;
            synchronized (atomicReference) {
                info = this.spreadsheetInfo.get();
                if (info == null) {
                    SpreadsheetMetadataExtractor metadataExtractor = new SpreadsheetMetadataExtractor();
                    metadataExtractor.setGdataAPI(this.gdata);
                    metadataExtractor.setVisualizationAPI(this.dataProtocol);
                    info = metadataExtractor.extractMetadata(this.config.getSpreadsheetName(), this.config.getKey());
                    this.spreadsheetInfo.set(info);
                }
            }
        }
        return info;
    }

    public UpdateResult executeListFeedUpdate(String worksheetTitle, String criteria, List<UpdateSet> set) {
        SpreadsheetInfo info = this.getSpreadsheetInfo();
        Worksheet sheet = info.getWorksheetByName(worksheetTitle);
        return this.gdata.listFeedUpdate(info.getSpreadsheetKey(), sheet.getId(), criteria, set, sheet.getColumnsAsList());
    }

    public UpdateResult deleteRows(String worksheetTitle, String criteria) {
        return this.gdata.listFeedDelete(this.getSpreadsheetInfo().getSpreadsheetKey(), this.getSpreadsheetInfo().getWorksheetByName(worksheetTitle).getId(), criteria);
    }

    public UpdateResult executeRowInsert(String worksheetTitle, Map<String, String> pair) {
        return this.gdata.listFeedInsert(this.getSpreadsheetInfo().getSpreadsheetKey(), this.getSpreadsheetInfo().getWorksheetByName(worksheetTitle).getId(), pair);
    }
}

