/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google;

import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.teiid.core.BundleUtil;
import org.teiid.resource.adapter.google.SpreadsheetConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;

public class SpreadsheetManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = -1832915223199053471L;
    public static final String OAUTH2_LOGIN = "OAuth2";
    private Integer batchSize = 4096;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(SpreadsheetManagedConnectionFactory.class);
    public static final String SPREADSHEET_NAME = "SpreadsheetName";
    private String spreadsheetName;
    private String authMethod = "OAuth2";
    private String refreshToken;
    private String clientId;
    private String clientSecret;
    private Boolean key = false;

    public BasicConnectionFactory<SpreadsheetConnectionImpl> createConnectionFactory() throws ResourceException {
        this.checkConfig();
        return new BasicConnectionFactory<SpreadsheetConnectionImpl>(){
            private AtomicReference<SpreadsheetInfo> spreadsheetInfo = new AtomicReference();

            public SpreadsheetConnectionImpl getConnection() throws ResourceException {
                return new SpreadsheetConnectionImpl(SpreadsheetManagedConnectionFactory.this, this.spreadsheetInfo);
            }
        };
    }

    private void checkConfig() throws ResourceException {
        if (this.getSpreadsheetName() == null || this.getSpreadsheetName().trim().equals("")) {
            throw new InvalidPropertyException(UTIL.getString("provide_spreadsheetname", new Object[]{SPREADSHEET_NAME}));
        }
        if (this.getAuthMethod() != null && !this.getAuthMethod().equals(OAUTH2_LOGIN)) {
            throw new InvalidPropertyException(UTIL.getString("provide_auth", new Object[]{OAUTH2_LOGIN}));
        }
        if (this.getRefreshToken() == null || this.getRefreshToken().trim().equals("")) {
            throw new InvalidPropertyException(UTIL.getString("oauth_requires_pass"));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authMethod == null ? 0 : this.authMethod.hashCode());
        result = 31 * result + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.refreshToken == null ? 0 : this.refreshToken.hashCode());
        result = 31 * result + (this.spreadsheetName == null ? 0 : this.spreadsheetName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SpreadsheetManagedConnectionFactory other = (SpreadsheetManagedConnectionFactory)((Object)obj);
        if (this.authMethod == null ? other.authMethod != null : !this.authMethod.equals(other.authMethod)) {
            return false;
        }
        if (this.batchSize == null ? other.batchSize != null : !this.batchSize.equals(other.batchSize)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.clientSecret == null ? other.clientSecret != null : !this.clientSecret.equals(other.clientSecret)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.refreshToken == null ? other.refreshToken != null : !this.refreshToken.equals(other.refreshToken)) {
            return false;
        }
        return !(this.spreadsheetName == null ? other.spreadsheetName != null : !this.spreadsheetName.equals(other.spreadsheetName));
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getSpreadsheetName() {
        return this.spreadsheetName;
    }

    public void setSpreadsheetName(String spreadsheetName) {
        this.spreadsheetName = spreadsheetName;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Boolean getKey() {
        return this.key;
    }

    public void setKey(Boolean key) {
        if (key == null) {
            key = false;
        }
        this.key = key;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }
}

