/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.gdata;

import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.util.List;
import org.teiid.resource.adapter.google.SpreadsheetManagedConnectionFactory;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.resource.adapter.google.gdata.GDataClientLoginAPI;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.Column;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Worksheet;

public class SpreadsheetMetadataExtractor {
    private GDataClientLoginAPI gdataAPI = null;
    private GoogleDataProtocolAPI visualizationAPI = null;

    public GoogleDataProtocolAPI getVisualizationAPI() {
        return this.visualizationAPI;
    }

    public void setVisualizationAPI(GoogleDataProtocolAPI visualizationAPI) {
        this.visualizationAPI = visualizationAPI;
    }

    public GDataClientLoginAPI getGdataAPI() {
        return this.gdataAPI;
    }

    public void setGdataAPI(GDataClientLoginAPI gdataAPI) {
        this.gdataAPI = gdataAPI;
    }

    public SpreadsheetInfo extractMetadata(String spreadsheetName, boolean isKey) {
        SpreadsheetEntry sentry = this.gdataAPI.getSpreadsheetEntry(spreadsheetName, isKey);
        SpreadsheetInfo metadata = new SpreadsheetInfo(spreadsheetName);
        metadata.setSpreadsheetKey(sentry.getKey());
        try {
            for (WorksheetEntry wentry : sentry.getWorksheets()) {
                String title = wentry.getTitle().getPlainText();
                Worksheet worksheet = metadata.createWorksheet(title);
                worksheet.setId(wentry.getId().substring(wentry.getId().lastIndexOf(47) + 1));
                List<Column> cols = this.visualizationAPI.getMetadata(sentry.getKey(), title);
                if (!cols.isEmpty() && cols.get(0).getLabel() != null) {
                    worksheet.setHeaderEnabled(true);
                }
                for (Column c : cols) {
                    worksheet.addColumn(c.getLabel() != null ? c.getLabel() : c.getAlphaName(), c);
                }
            }
        }
        catch (IOException ex) {
            throw new SpreadsheetOperationException(SpreadsheetManagedConnectionFactory.UTIL.gs("metadata_error", new Object[0]), (Throwable)ex);
        }
        catch (ServiceException ex) {
            throw new SpreadsheetOperationException(SpreadsheetManagedConnectionFactory.UTIL.gs("metadata_error", new Object[0]), (Throwable)ex);
        }
        return metadata;
    }
}

