/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.auth;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.teiid.resource.adapter.google.auth.OAuth2Tokens;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.resource.adapter.google.dataprotocol.GoogleJSONParser;
import org.teiid.translator.google.api.SpreadsheetAuthException;

public class OAuth2Authenticator {
    static final String CLIENT_ID = "217138521084.apps.googleusercontent.com";
    static final String CLIENT_SECRET = "gXQ6-lOkEjE1lVcz7giB4Poy";
    private final String TOKEN_URL = "https://accounts.google.com/o/oauth2/token";

    public OAuth2Tokens refreshToken(OAuth2Tokens at, String clientId, String clientSecret) {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("client_id", clientId));
        nvps.add((NameValuePair)new BasicNameValuePair("client_secret", clientSecret));
        nvps.add((NameValuePair)new BasicNameValuePair("refresh_token", at.getRefreshToken()));
        nvps.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        Map<?, ?> json = this.jsonResponseHttpPost("https://accounts.google.com/o/oauth2/token", nvps);
        return new OAuth2Tokens(json.get("access_token"), at.getRefreshToken(), json.get("expires_in"));
    }

    private Map<?, ?> jsonResponseHttpPost(String url, List<NameValuePair> data) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(data));
            response = httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception ex) {
            throw new SpreadsheetAuthException("Error when attempting Http Request to OAuth2", (Throwable)ex);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            String msg = null;
            msg = response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase();
            throw new SpreadsheetAuthException("Error when attempting OAuth2 process: " + msg);
        }
        InputStream is = null;
        try {
            is = response.getEntity().getContent();
            GoogleJSONParser parser = new GoogleJSONParser();
            Map jsonResponse = (Map)parser.parseObject(new InputStreamReader(is, Charset.forName(GoogleDataProtocolAPI.ENCODING)), false);
            if (jsonResponse.get("error") != null) {
                throw new SpreadsheetAuthException("OAuth2 service says: " + jsonResponse.get("error"));
            }
            Map map = jsonResponse;
            return map;
        }
        catch (IOException e) {
            throw new SpreadsheetAuthException("Error reading Client Login response", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

