/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.google.SpreadsheetManagedConnectionFactory;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.resource.adapter.google.gdata.GDataClientLoginAPI;
import org.teiid.resource.adapter.google.gdata.SpreadsheetMetadataExtractor;
import org.teiid.resource.adapter.google.v4.OAuth2HeaderFactory;
import org.teiid.resource.adapter.google.v4.SheetsAPI;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.UpdateSet;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Worksheet;
import org.teiid.translator.google.api.result.RowsResult;
import org.teiid.translator.google.api.result.UpdateResult;

public class SpreadsheetConnectionImpl4
extends BasicConnection
implements GoogleSpreadsheetConnection {
    private SpreadsheetManagedConnectionFactory config;
    private SheetsAPI sheetsAPI = null;
    private GoogleDataProtocolAPI googleDataProtocolAPI;
    private GDataClientLoginAPI gdata;
    private AtomicReference<SpreadsheetInfo> spreadsheetInfo;
    private AtomicReference<SpreadsheetInfo> v2spreadsheetInfo;

    public SpreadsheetConnectionImpl4(SpreadsheetManagedConnectionFactory config, AtomicReference<SpreadsheetInfo> spreadsheetInfo, AtomicReference<SpreadsheetInfo> v2SpreadsheetInfo) {
        this.config = config;
        this.spreadsheetInfo = spreadsheetInfo;
        this.v2spreadsheetInfo = v2SpreadsheetInfo;
        String refreshToken = config.getRefreshToken().trim();
        OAuth2HeaderFactory authHeaderFactory = new OAuth2HeaderFactory(refreshToken, config.getClientId(), config.getClientSecret());
        authHeaderFactory.refreshToken();
        this.sheetsAPI = new SheetsAPI(authHeaderFactory);
        this.googleDataProtocolAPI = new GoogleDataProtocolAPI();
        this.googleDataProtocolAPI.setHeaderFactory(authHeaderFactory);
        this.gdata = new GDataClientLoginAPI();
        this.gdata.setHeaderFactory(authHeaderFactory);
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SpreadsheetManagedConnectionFactory.UTIL.getString("init"));
    }

    public void close() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SpreadsheetManagedConnectionFactory.UTIL.getString("closing"));
    }

    public boolean isAlive() {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)SpreadsheetManagedConnectionFactory.UTIL.getString("alive"));
        return true;
    }

    public RowsResult executeQuery(String worksheetTitle, String query, Integer offset, Integer limit, int batchSize) {
        return this.googleDataProtocolAPI.executeQuery(this.getSpreadsheetInfo(), worksheetTitle, query, Math.min(batchSize, this.config.getBatchSize()), offset, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpreadsheetInfo getSpreadsheetInfo() {
        SpreadsheetInfo info = this.spreadsheetInfo.get();
        if (info == null) {
            AtomicReference<SpreadsheetInfo> atomicReference = this.spreadsheetInfo;
            synchronized (atomicReference) {
                info = this.spreadsheetInfo.get();
                if (info == null) {
                    org.teiid.resource.adapter.google.v4.SpreadsheetMetadataExtractor metadataExtractor = new org.teiid.resource.adapter.google.v4.SpreadsheetMetadataExtractor(this.sheetsAPI, this.googleDataProtocolAPI);
                    info = metadataExtractor.extractMetadata(this.config.getSpreadsheetId());
                    this.spreadsheetInfo.set(info);
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpreadsheetInfo getV2SpreadsheetInfo() {
        SpreadsheetInfo info = this.v2spreadsheetInfo.get();
        if (info == null) {
            AtomicReference<SpreadsheetInfo> atomicReference = this.v2spreadsheetInfo;
            synchronized (atomicReference) {
                info = this.v2spreadsheetInfo.get();
                if (info == null) {
                    SpreadsheetMetadataExtractor metadataExtractor = new SpreadsheetMetadataExtractor();
                    metadataExtractor.setVisualizationAPI(this.googleDataProtocolAPI);
                    metadataExtractor.setGdataAPI(this.gdata);
                    info = metadataExtractor.extractMetadata(this.config.getSpreadsheetId(), true);
                    this.v2spreadsheetInfo.set(info);
                }
            }
        }
        return info;
    }

    public UpdateResult updateRows(String worksheetTitle, String criteria, List<UpdateSet> set) {
        SpreadsheetInfo info = this.getV2SpreadsheetInfo();
        Worksheet sheet = info.getWorksheetByName(worksheetTitle);
        if (sheet == null) {
            throw new SpreadsheetOperationException(SpreadsheetManagedConnectionFactory.UTIL.getString("not_visible"));
        }
        return this.gdata.listFeedUpdate(info.getSpreadsheetKey(), sheet.getId(), criteria, set, sheet.getColumnsAsList());
    }

    public UpdateResult deleteRows(String worksheetTitle, String criteria) {
        SpreadsheetInfo info = this.getV2SpreadsheetInfo();
        Worksheet sheet = info.getWorksheetByName(worksheetTitle);
        if (sheet == null) {
            throw new SpreadsheetOperationException(SpreadsheetManagedConnectionFactory.UTIL.getString("not_visible"));
        }
        return this.gdata.listFeedDelete(info.getSpreadsheetKey(), sheet.getId(), criteria);
    }

    public UpdateResult executeRowInsert(String worksheetTitle, Map<String, Object> pairs) {
        return this.sheetsAPI.insert(this.getSpreadsheetInfo().getSpreadsheetKey(), pairs, this.getSpreadsheetInfo().getWorksheetByName(worksheetTitle));
    }
}

