/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google;

import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.teiid.core.BundleUtil;
import org.teiid.resource.adapter.google.SpreadsheetConnectionImpl;
import org.teiid.resource.adapter.google.SpreadsheetConnectionImpl4;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;

public class SpreadsheetManagedConnectionFactory
extends BasicManagedConnectionFactory {
    public static final String V_3 = "v3";
    public static final String V_4 = "v4";
    private static final long serialVersionUID = -1832915223199053471L;
    private Integer batchSize = 4096;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(SpreadsheetManagedConnectionFactory.class);
    public static final String SPREADSHEET_NAME = "SpreadsheetName";
    private String spreadsheetName;
    private String spreadsheetId;
    private String apiVersion = "v3";
    private String refreshToken;
    private String clientId;
    private String clientSecret;

    public BasicConnectionFactory<BasicConnection> createConnectionFactory() throws ResourceException {
        this.checkConfig();
        return new BasicConnectionFactory<BasicConnection>(){
            private AtomicReference<SpreadsheetInfo> spreadsheetInfo = new AtomicReference();
            private AtomicReference<SpreadsheetInfo> v2SpreadsheetInfo = new AtomicReference();

            public BasicConnection getConnection() throws ResourceException {
                if (SpreadsheetManagedConnectionFactory.this.apiVersion.equals(SpreadsheetManagedConnectionFactory.V_3)) {
                    return new SpreadsheetConnectionImpl(SpreadsheetManagedConnectionFactory.this, this.spreadsheetInfo);
                }
                return new SpreadsheetConnectionImpl4(SpreadsheetManagedConnectionFactory.this, this.spreadsheetInfo, this.v2SpreadsheetInfo);
            }
        };
    }

    private void checkConfig() throws ResourceException {
        if ((this.getSpreadsheetName() == null || this.getSpreadsheetName().trim().equals("")) && this.getSpreadsheetId() == null) {
            throw new InvalidPropertyException(UTIL.getString("provide_spreadsheetname", new Object[]{SPREADSHEET_NAME}));
        }
        if (this.apiVersion == null || !this.apiVersion.equals(V_3) && !this.apiVersion.equals(V_4)) {
            throw new InvalidPropertyException(UTIL.getString("invalid_protocol"));
        }
        if (this.getRefreshToken() == null || this.getRefreshToken().trim().equals("")) {
            throw new InvalidPropertyException(UTIL.getString("oauth_requires"));
        }
        if (this.apiVersion.equals(V_4)) {
            if (this.getClientId() == null || this.getClientSecret() == null) {
                throw new InvalidPropertyException(UTIL.getString("oauth_requires"));
            }
            if (this.getSpreadsheetId() == null) {
                throw new InvalidPropertyException(UTIL.getString("v4_sheet_id"));
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = 31 * result + (this.refreshToken == null ? 0 : this.refreshToken.hashCode());
        result = 31 * result + (this.spreadsheetName == null ? 0 : this.spreadsheetName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SpreadsheetManagedConnectionFactory other = (SpreadsheetManagedConnectionFactory)((Object)obj);
        if (this.batchSize == null ? other.batchSize != null : !this.batchSize.equals(other.batchSize)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.clientSecret == null ? other.clientSecret != null : !this.clientSecret.equals(other.clientSecret)) {
            return false;
        }
        if (this.refreshToken == null ? other.refreshToken != null : !this.refreshToken.equals(other.refreshToken)) {
            return false;
        }
        if (this.spreadsheetName == null ? other.spreadsheetName != null : !this.spreadsheetName.equals(other.spreadsheetName)) {
            return false;
        }
        if (this.spreadsheetId == null ? other.spreadsheetId != null : !this.spreadsheetId.equals(other.spreadsheetId)) {
            return false;
        }
        return !(this.apiVersion == null ? other.apiVersion != null : !this.apiVersion.equals(other.apiVersion));
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public String getSpreadsheetName() {
        return this.spreadsheetName;
    }

    public void setSpreadsheetName(String spreadsheetName) {
        this.spreadsheetName = spreadsheetName;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getSpreadsheetId() {
        return this.spreadsheetId;
    }

    public void setSpreadsheetId(String spreadsheetId) {
        this.spreadsheetId = spreadsheetId;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

