/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.v4;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.teiid.resource.adapter.google.v4.ClientConstants;
import org.teiid.resource.adapter.google.v4.OAuth2HeaderFactory;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.Worksheet;
import org.teiid.translator.google.api.result.UpdateResult;

public class SheetsAPI {
    private Sheets service;

    public SheetsAPI(OAuth2HeaderFactory headerFactory) {
        this.service = new Sheets.Builder(ClientConstants.HTTP_TRANSPORT, ClientConstants.JSON_FACTORY, (HttpRequestInitializer)headerFactory.getCredential()).setApplicationName("GdataSpreadsheetBrowser").build();
    }

    public Spreadsheet getSpreadsheet(String spreadsheetId) throws IOException {
        return (Spreadsheet)this.service.spreadsheets().get(spreadsheetId).execute();
    }

    public UpdateResult insert(String spreadsheetId, Map<String, Object> pairs, Worksheet worksheet) {
        ValueRange content = new ValueRange();
        ArrayList<Object> row = new ArrayList<Object>();
        for (String label : worksheet.getColumns().keySet()) {
            Object value = pairs.get(label);
            if (value != null) {
                if (value instanceof String) {
                    value = "'" + value;
                } else if (!(value instanceof Boolean) && !(value instanceof Double)) {
                    value = value.toString();
                }
            }
            row.add(value);
        }
        content.setValues(Arrays.asList(row));
        try {
            this.service.spreadsheets().values().append(spreadsheetId, worksheet.getName(), content).setValueInputOption("USER_ENTERED").execute();
        }
        catch (IOException e) {
            throw new SpreadsheetOperationException("Error inserting spreadsheet row", (Throwable)e);
        }
        return new UpdateResult(1, 1);
    }
}

