/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.dataprotocol;

import com.google.gdata.client.spreadsheet.SpreadsheetQuery;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.spreadsheet.ListEntry;
import com.google.gdata.data.spreadsheet.ListFeed;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.resource.adapter.google.gdata.GDataClientLoginAPI;
import org.teiid.translator.google.api.UpdateSet;
import org.teiid.translator.google.api.metadata.Column;
import org.teiid.translator.google.api.metadata.SpreadsheetColumnType;

public class TestGoogleDataProtocolAPI {
    @Test
    public void testValueConversion() {
        Date date = (Date)GoogleDataProtocolAPI.convertValue(null, (Object)"Date(2001,0,1)", (SpreadsheetColumnType)SpreadsheetColumnType.DATE);
        Assert.assertEquals((Object)"2001-01-01", (Object)date.toString());
        Timestamp ts = (Timestamp)GoogleDataProtocolAPI.convertValue(null, (Object)"Date(2001,0,1,1,2,3)", (SpreadsheetColumnType)SpreadsheetColumnType.DATETIME);
        Assert.assertEquals((Object)"2001-01-01 01:02:03.0", (Object)ts.toString());
        Time t = (Time)GoogleDataProtocolAPI.convertValue(null, Arrays.asList(1.0, 2.0, 3.0, 4.0), (SpreadsheetColumnType)SpreadsheetColumnType.TIMEOFDAY);
        Assert.assertEquals((Object)"01:02:03", (Object)t.toString());
    }

    @Test
    public void testColumnsWithoutLabel() {
        GDataClientLoginAPI api = new GDataClientLoginAPI(){

            protected BaseFeed<?, ?> getSpreadsheetFeedQuery(SpreadsheetQuery squery, Class<? extends BaseFeed<?, ?>> feedClass) {
                ListFeed lf = new ListFeed();
                lf.setEntries(Arrays.asList(new ListEntry()));
                return lf;
            }
        };
        Column c1 = new Column();
        c1.setLabel("valid");
        c1.setDataType(SpreadsheetColumnType.STRING);
        c1.setAlphaName("A");
        Column c2 = new Column();
        c2.setDataType(SpreadsheetColumnType.STRING);
        c2.setAlphaName("B");
        api.listFeedUpdate("x", "y", "", Arrays.asList(new UpdateSet("valid", "value")), Arrays.asList(c1, c2));
    }
}

