/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.v4;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import java.io.IOException;
import org.teiid.resource.adapter.google.auth.AuthHeaderFactory;
import org.teiid.resource.adapter.google.v4.ClientConstants;
import org.teiid.translator.google.api.SpreadsheetAuthException;

public class OAuth2HeaderFactory
implements AuthHeaderFactory {
    private GoogleCredential credential = null;
    private String refreshToken;
    private String clientId;
    private String clientSecret;

    public OAuth2HeaderFactory(String refreshToken, String clientId, String clientSecret) {
        this.refreshToken = refreshToken;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public void refreshToken() {
        try {
            if (this.credential == null) {
                this.credential = new GoogleCredential.Builder().setClientSecrets(this.clientId, this.clientSecret).setTransport(ClientConstants.HTTP_TRANSPORT).setJsonFactory(ClientConstants.JSON_FACTORY).build();
                this.credential.setRefreshToken(this.refreshToken);
            }
            this.credential.refreshToken();
        }
        catch (IOException e) {
            throw new SpreadsheetAuthException("Error reading TokenRequest response", (Throwable)e);
        }
    }

    @Override
    public String getAuthHeader() {
        return "Bearer " + this.credential.getAccessToken();
    }

    public GoogleCredential getCredential() {
        return this.credential;
    }
}

