/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.dataprotocol;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import org.teiid.core.util.StringUtil;
import org.teiid.translator.google.api.SpreadsheetOperationException;

public class GoogleJSONParser {
    private Calendar cal;
    private int[] parts = new int[7];
    private StringBuilder sb = new StringBuilder();
    private ReaderCharSequence charSequence = new ReaderCharSequence();

    public Object parseObject(Reader r, boolean wrapped) throws IOException {
        block1: {
            int c;
            if (!wrapped) break block1;
            do {
                if ((c = r.read()) != -1) continue;
                return null;
            } while (c != 40);
        }
        return this.parseObject(new PushbackReader(r), this.skipWhitespace(r));
    }

    private Object parseObject(PushbackReader r, int c) throws IOException {
        switch (c) {
            case 123: {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                block14: while (true) {
                    c = this.skipWhitespace(r);
                    switch (c) {
                        case 125: {
                            return map;
                        }
                        case 44: {
                            continue block14;
                        }
                    }
                    String s = this.parseString(r, c);
                    c = this.skipWhitespace(r);
                    if (c != 58) {
                        throw new SpreadsheetOperationException("Expected : in object name value pair");
                    }
                    c = this.skipWhitespace(r);
                    Object o = this.parseObject(r, c);
                    map.put(s, o);
                }
            }
            case 91: {
                ArrayList<Object> array = new ArrayList<Object>();
                boolean seenComma = true;
                block15: while (true) {
                    c = this.skipWhitespace(r);
                    switch (c) {
                        case 44: {
                            if (seenComma) {
                                array.add(null);
                            }
                            seenComma = true;
                            continue block15;
                        }
                        case 93: {
                            return array;
                        }
                    }
                    seenComma = false;
                    Object o = this.parseObject(r, c);
                    array.add(o);
                }
            }
            case -1: {
                return null;
            }
            case 34: 
            case 39: {
                return this.parseString(r, c);
            }
        }
        return this.parseLiteral(r, (char)c);
    }

    private Object parseLiteral(PushbackReader r, char c) throws IOException {
        int i;
        this.sb.setLength(0);
        do {
            this.sb.append(c);
        } while ((i = r.read()) != -1 && !Character.isWhitespace(c = (char)i) && c != ',' && c != ']' && c != '}');
        if (this.areEquals(this.sb, "new")) {
            this.sb.setLength(0);
            int length = 0;
            Arrays.fill(this.parts, 0);
            int i2 = 0;
            while (true) {
                int chr;
                if (i2 > 5) {
                    if (c == ',' || c == ')') {
                        if (length > 6) {
                            throw new SpreadsheetOperationException("Too many date fields");
                        }
                        this.parts[length++] = Integer.valueOf(this.sb.toString());
                        if (c == ')') break;
                        this.sb.setLength(0);
                    } else {
                        this.sb.append(c);
                    }
                }
                if ((chr = r.read()) == -1) {
                    throw new SpreadsheetOperationException("Encountered end of stream in date value");
                }
                c = (char)chr;
                ++i2;
            }
            if (length > 3) {
                Calendar calendar = this.getCalendar();
                calendar.set(this.parts[0], this.parts[1], this.parts[2], this.parts[3], this.parts[4], this.parts[5]);
                Timestamp ts = new Timestamp(calendar.getTimeInMillis());
                ts.setNanos(this.parts[6] * 1000000);
                return ts;
            }
            Calendar calendar = this.getCalendar();
            calendar.set(this.parts[0], this.parts[1], this.parts[2]);
            return new Date(this.cal.getTimeInMillis());
        }
        if (!Character.isWhitespace(c)) {
            r.unread(c);
        }
        if (this.areEquals(this.sb, "false")) {
            return Boolean.FALSE;
        }
        if (this.areEquals(this.sb, "true")) {
            return Boolean.TRUE;
        }
        if (this.areEquals(this.sb, "null")) {
            return null;
        }
        return Double.valueOf(this.sb.toString());
    }

    private boolean areEquals(CharSequence cs, CharSequence cs1) {
        if (cs.length() != cs1.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (cs.charAt(i) == cs1.charAt(i)) continue;
            return false;
        }
        return true;
    }

    Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
        }
        this.cal.clear();
        return this.cal;
    }

    public void setCalendar(Calendar cal) {
        this.cal = cal;
    }

    private String parseString(Reader r, int quoteChar) {
        if (quoteChar != 34 && quoteChar != 39) {
            throw new IllegalStateException();
        }
        this.charSequence.i = -1;
        this.charSequence.r = r;
        this.sb.setLength(0);
        return StringUtil.unescape((CharSequence)this.charSequence, (int)quoteChar, (boolean)false, (StringBuilder)this.sb);
    }

    private int skipWhitespace(Reader r) throws IOException {
        int c;
        do {
            if ((c = r.read()) != -1) continue;
            return c;
        } while (Character.isWhitespace((char)c));
        return c;
    }

    private static final class ReaderCharSequence
    implements CharSequence {
        Reader r;
        int i = -1;

        private ReaderCharSequence() {
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int length() {
            return Integer.MAX_VALUE;
        }

        @Override
        public char charAt(int index) {
            int result;
            if (index != ++this.i) {
                throw new IllegalStateException();
            }
            try {
                result = this.r.read();
            }
            catch (IOException e) {
                throw new SpreadsheetOperationException((Throwable)e);
            }
            if (result == -1) {
                throw new SpreadsheetOperationException("Read end of stream before the end of a string value");
            }
            return (char)result;
        }
    }
}

