/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.resource.adapter.google.auth.AuthHeaderFactory;
import org.teiid.resource.adapter.google.auth.OAuth2HeaderFactory;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.resource.adapter.google.gdata.GDataClientLoginAPI;
import org.teiid.resource.adapter.google.integration.IntegrationTest;
import org.teiid.translator.google.api.result.PartialResultExecutor;
import org.teiid.translator.google.api.result.SheetRow;

@Ignore
public class SpreadsheetDataRetrievalTest
extends IntegrationTest {
    private String SPREADSHEET_KEY = "0Ajbs6-5EEwQqdFBSelpZT1FuZ2EwSFZaTTJVbGZVeGc";
    private static GoogleDataProtocolAPI dataProtocol = null;
    private static GDataClientLoginAPI gdata = null;

    @BeforeClass
    public static void prepareGoogleData() {
        dataProtocol = new GoogleDataProtocolAPI();
        OAuth2HeaderFactory headerFactory = new OAuth2HeaderFactory(refreshToken);
        dataProtocol.setHeaderFactory((AuthHeaderFactory)headerFactory);
        gdata = new GDataClientLoginAPI();
        gdata.setHeaderFactory((AuthHeaderFactory)headerFactory);
    }

    @Test
    public void vSimple() {
        GoogleDataProtocolAPI googleDataProtocolAPI = dataProtocol;
        googleDataProtocolAPI.getClass();
        GoogleDataProtocolAPI.DataProtocolQueryStrategy dpqs = new GoogleDataProtocolAPI.DataProtocolQueryStrategy(googleDataProtocolAPI, this.SPREADSHEET_KEY, "s1", "");
        this.assertSimpleResultDataProtorol((PartialResultExecutor)dpqs);
    }

    private void assertSimpleResultDataProtorol(PartialResultExecutor partialExecutor) {
        List result = partialExecutor.getResultsBatch(0, 4);
        Assert.assertEquals((Object)new SheetRow(new String[]{"0", "Michal", "Abaffy", "$26,000", "Brno", "01-17-1987"}), result.get(0));
        Assert.assertEquals((Object)new SheetRow(new String[]{"2", "Filip", "Eli\u00e1\u0161", "$50,000", "Brno", "02-18-1974"}), result.get(1));
        Assert.assertEquals((int)4, (int)result.size());
        result = partialExecutor.getResultsBatch(1, 13);
        Assert.assertEquals((int)11, (int)result.size());
        result = partialExecutor.getResultsBatch(10, 3);
        Assert.assertEquals((Object)new SheetRow(new String[]{"11", "Pavel", "Macik", "$28,000", "Bratislava", "04-08-1954"}), result.get(1));
        Assert.assertEquals((int)2, (int)result.size());
        result = partialExecutor.getResultsBatch(13, 2);
        Assert.assertEquals((int)0, (int)result.size());
    }

    private List<SheetRow> query(String string, String string2, int i, int j) {
        GoogleDataProtocolAPI googleDataProtocolAPI = dataProtocol;
        googleDataProtocolAPI.getClass();
        GoogleDataProtocolAPI.DataProtocolQueryStrategy dpqs = new GoogleDataProtocolAPI.DataProtocolQueryStrategy(googleDataProtocolAPI, this.SPREADSHEET_KEY, string, string2);
        return dpqs.getResultsBatch(i, j);
    }

    @Test
    public void vSelect() {
        List<SheetRow> result = this.query("s1", "SELECT A", 0, 12);
        Assert.assertEquals((int)12, (int)result.size());
        Assert.assertEquals((int)1, (int)result.get(0).getRow().size());
        Assert.assertEquals((Object)"0", result.get(0).getRow().get(0));
        Assert.assertEquals((Object)"2", result.get(1).getRow().get(0));
        Assert.assertEquals((Object)"3", result.get(2).getRow().get(0));
    }

    @Test
    public void vWhere() {
        List<SheetRow> result = this.query("s1", "WHERE B='Filip'", 0, 12);
        Assert.assertEquals((int)2, (int)result.size());
        result = this.query("s1", "WHERE B='Filip' and C='Eli\u00e1\u0161'", 0, 12);
        Assert.assertEquals((int)1, (int)result.size());
        result = this.query("s1", "WHERE C starts with 'E'", 0, 12);
        Assert.assertEquals((int)1, (int)result.size());
    }

    @Test
    public void vGroupBy() {
        List<SheetRow> result = this.query("s1", "SELECT E,max(D) GROUP BY E", 0, 12);
        Assert.assertEquals((int)3, (int)result.size());
        Assert.assertEquals((Object)new SheetRow(new String[]{"Brno", "50,000"}), (Object)result.get(1));
        Assert.assertEquals((Object)new SheetRow(new String[]{"Praha", "66,000"}), (Object)result.get(2));
        Assert.assertEquals((Object)new SheetRow(new String[]{"Bratislava", "60,000"}), (Object)result.get(0));
    }

    @Test
    public void vFormat() {
        List<SheetRow> result = this.query("s1", "SELECT D where A = 2 format D '#,##0.00'", 0, 12);
        Assert.assertEquals((int)1, (int)result.size());
    }
}

