/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.v4;

import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import java.io.IOException;
import java.util.List;
import org.teiid.resource.adapter.google.SpreadsheetManagedConnectionFactory;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.resource.adapter.google.v4.SheetsAPI;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.Column;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Worksheet;

public class SpreadsheetMetadataExtractor {
    private SheetsAPI sheetsAPI = null;
    private GoogleDataProtocolAPI dataProtocolAPI;

    public SpreadsheetMetadataExtractor(SheetsAPI api, GoogleDataProtocolAPI dataProtocolAPI) {
        this.sheetsAPI = api;
        this.dataProtocolAPI = dataProtocolAPI;
    }

    public SpreadsheetInfo extractMetadata(String spreadsheetId) {
        try {
            Spreadsheet spreadsheet = this.sheetsAPI.getSpreadsheet(spreadsheetId);
            SpreadsheetInfo metadata = new SpreadsheetInfo(spreadsheet.getProperties().getTitle());
            metadata.setSpreadsheetKey(spreadsheet.getSpreadsheetId());
            for (Sheet sheet : spreadsheet.getSheets()) {
                String title = sheet.getProperties().getTitle();
                Worksheet worksheet = metadata.createWorksheet(title);
                worksheet.setId(sheet.getProperties().getSheetId().toString());
                List<Column> cols = this.dataProtocolAPI.getMetadata(spreadsheet.getSpreadsheetId(), title);
                if (!cols.isEmpty() && cols.get(0).getLabel() != null) {
                    worksheet.setHeaderEnabled(true);
                }
                for (Column c : cols) {
                    worksheet.addColumn(c.getLabel() != null ? c.getLabel() : c.getAlphaName(), c);
                }
            }
            return metadata;
        }
        catch (IOException ex) {
            throw new SpreadsheetOperationException(SpreadsheetManagedConnectionFactory.UTIL.gs("metadata_error", new Object[0]), (Throwable)ex);
        }
    }
}

