/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.infinispan.api;

import javax.resource.ResourceException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.teiid.infinispan.api.InfinispanConnection;
import org.teiid.resource.adapter.infinispan.hotrod.InfinispanConnectionImpl;
import org.teiid.resource.adapter.infinispan.hotrod.InfinispanManagedConnectionFactory;
import org.teiid.resource.spi.BasicConnectionFactory;

public class HotRodTestServer {
    private HotRodServer server;
    private DefaultCacheManager defaultCacheManager;
    private BasicConnectionFactory<InfinispanConnectionImpl> connectionFactory;

    public HotRodTestServer(int port) {
        ConfigurationBuilder c = new ConfigurationBuilder();
        GlobalConfigurationBuilder gc = GlobalConfigurationBuilder.defaultClusteredBuilder().nonClusteredDefault();
        GlobalConfiguration config = gc.build();
        this.defaultCacheManager = new DefaultCacheManager(config, c.build(config));
        this.defaultCacheManager.defineConfiguration("default", this.getConfigurationBuilder().build());
        this.defaultCacheManager.startCaches(new String[]{"default"});
        this.defaultCacheManager.getCache();
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        this.server = new HotRodServer();
        ((HotRodServerConfigurationBuilder)builder.host("127.0.0.1")).port(port);
        this.server.start((ProtocolServerConfiguration)builder.build(), (EmbeddedCacheManager)this.defaultCacheManager);
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    public InfinispanConnection getConnection() throws ResourceException {
        if (this.connectionFactory == null) {
            InfinispanManagedConnectionFactory factory = new InfinispanManagedConnectionFactory();
            factory.setCacheName("default");
            factory.setRemoteServerList("127.0.0.1:" + this.server.getPort());
            this.connectionFactory = factory.createConnectionFactory();
        }
        return (InfinispanConnection)this.connectionFactory.getConnection();
    }

    public void stop() {
        if (this.server != null) {
            this.defaultCacheManager.stop();
            this.server.stop();
        }
        this.defaultCacheManager = null;
        this.server = null;
    }
}

