/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.infinispan.hotrod;

import java.io.IOException;
import javax.resource.ResourceException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.teiid.core.BundleUtil;
import org.teiid.infinispan.api.ProtobufResource;
import org.teiid.resource.adapter.infinispan.hotrod.InfinispanConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.translator.TranslatorException;

public class InfinispanManagedConnectionFactory
extends BasicManagedConnectionFactory {
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(InfinispanManagedConnectionFactory.class);
    private static final long serialVersionUID = -4791974803005018658L;
    private String remoteServerList;
    private String cacheName;
    private static final String[] saslAllowed = new String[]{"CRAM-MD5", "DIGEST-MD5", "PLAIN"};
    private String saslMechanism;
    private String userName;
    private String password;
    private String authenticationRealm;
    private String authenticationServerName;
    private String trustStoreFileName = System.getProperty("javax.net.ssl.trustStore");
    private String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    private String keyStoreFileName = System.getProperty("javax.net.ssl.keyStore");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");

    public String getRemoteServerList() {
        return this.remoteServerList;
    }

    public void setRemoteServerList(String remoteServerList) {
        this.remoteServerList = remoteServerList;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public BasicConnectionFactory<InfinispanConnectionImpl> createConnectionFactory() throws ResourceException {
        return new InfinispanConnectionFactory();
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthenticationRealm() {
        return this.authenticationRealm;
    }

    public void setAuthenticationRealm(String authenticationRealm) {
        this.authenticationRealm = authenticationRealm;
    }

    public String getAuthenticationServerName() {
        return this.authenticationServerName;
    }

    public void setAuthenticationServerName(String authenticationServerName) {
        this.authenticationServerName = authenticationServerName;
    }

    public String getTrustStoreFileName() {
        return this.trustStoreFileName;
    }

    public void setTrustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getKeyStoreFileName() {
        return this.keyStoreFileName;
    }

    public void setKeyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authenticationRealm == null ? 0 : this.authenticationRealm.hashCode());
        result = 31 * result + (this.authenticationServerName == null ? 0 : this.authenticationServerName.hashCode());
        result = 31 * result + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        result = 31 * result + (this.keyStoreFileName == null ? 0 : this.keyStoreFileName.hashCode());
        result = 31 * result + (this.keyStorePassword == null ? 0 : this.keyStorePassword.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.remoteServerList == null ? 0 : this.remoteServerList.hashCode());
        result = 31 * result + (this.saslMechanism == null ? 0 : this.saslMechanism.hashCode());
        result = 31 * result + (this.trustStoreFileName == null ? 0 : this.trustStoreFileName.hashCode());
        result = 31 * result + (this.trustStorePassword == null ? 0 : this.trustStorePassword.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InfinispanManagedConnectionFactory other = (InfinispanManagedConnectionFactory)((Object)obj);
        if (this.authenticationRealm == null ? other.authenticationRealm != null : !this.authenticationRealm.equals(other.authenticationRealm)) {
            return false;
        }
        if (this.authenticationServerName == null ? other.authenticationServerName != null : !this.authenticationServerName.equals(other.authenticationServerName)) {
            return false;
        }
        if (this.cacheName == null ? other.cacheName != null : !this.cacheName.equals(other.cacheName)) {
            return false;
        }
        if (this.keyStoreFileName == null ? other.keyStoreFileName != null : !this.keyStoreFileName.equals(other.keyStoreFileName)) {
            return false;
        }
        if (this.keyStorePassword == null ? other.keyStorePassword != null : !this.keyStorePassword.equals(other.keyStorePassword)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.remoteServerList == null ? other.remoteServerList != null : !this.remoteServerList.equals(other.remoteServerList)) {
            return false;
        }
        if (this.saslMechanism == null ? other.saslMechanism != null : !this.saslMechanism.equals(other.saslMechanism)) {
            return false;
        }
        if (this.trustStoreFileName == null ? other.trustStoreFileName != null : !this.trustStoreFileName.equals(other.trustStoreFileName)) {
            return false;
        }
        if (this.trustStorePassword == null ? other.trustStorePassword != null : !this.trustStorePassword.equals(other.trustStorePassword)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    class InfinispanConnectionFactory
    extends BasicConnectionFactory<InfinispanConnectionImpl> {
        private static final long serialVersionUID = 1064143496037686580L;
        private RemoteCacheManager cacheManager;
        private RemoteCacheManager scriptCacheManager;
        private SerializationContext ctx;

        public InfinispanConnectionFactory() throws ResourceException {
            this.buildCacheManager();
            this.buildScriptCacheManager();
        }

        private void buildCacheManager() throws ResourceException {
            try {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.addServers(InfinispanManagedConnectionFactory.this.remoteServerList);
                builder.marshaller((Marshaller)new ProtoStreamMarshaller());
                this.handleSecurity(builder);
                this.cacheManager = new RemoteCacheManager(builder.build());
                this.cacheManager.start();
                this.ctx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.cacheManager);
            }
            catch (Throwable e) {
                throw new ResourceException(e);
            }
        }

        private void buildScriptCacheManager() throws ResourceException {
            try {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.addServers(InfinispanManagedConnectionFactory.this.remoteServerList);
                builder.marshaller((Marshaller)new GenericJBossMarshaller());
                this.handleSecurity(builder);
                this.scriptCacheManager = new RemoteCacheManager(builder.build());
                this.scriptCacheManager.start();
            }
            catch (Throwable e) {
                throw new ResourceException(e);
            }
        }

        public void handleSecurity(ConfigurationBuilder builder) throws ResourceException {
            if (InfinispanManagedConnectionFactory.this.saslMechanism != null && this.supportedSasl(InfinispanManagedConnectionFactory.this.saslMechanism)) {
                if (InfinispanManagedConnectionFactory.this.userName == null) {
                    throw new ResourceException(UTIL.getString("no_user"));
                }
                if (InfinispanManagedConnectionFactory.this.password == null) {
                    throw new ResourceException(UTIL.getString("no_pass"));
                }
                if (InfinispanManagedConnectionFactory.this.authenticationRealm == null) {
                    throw new ResourceException(UTIL.getString("no_realm"));
                }
                if (InfinispanManagedConnectionFactory.this.authenticationServerName == null) {
                    throw new ResourceException(UTIL.getString("no_auth_server"));
                }
                builder.security().authentication().enable().saslMechanism(InfinispanManagedConnectionFactory.this.saslMechanism).username(InfinispanManagedConnectionFactory.this.userName).realm(InfinispanManagedConnectionFactory.this.authenticationRealm).password(InfinispanManagedConnectionFactory.this.password).serverName(InfinispanManagedConnectionFactory.this.authenticationServerName);
            } else if (InfinispanManagedConnectionFactory.this.saslMechanism != null && InfinispanManagedConnectionFactory.this.saslMechanism.equals("EXTERNAL")) {
                if (InfinispanManagedConnectionFactory.this.keyStoreFileName == null || InfinispanManagedConnectionFactory.this.keyStoreFileName.isEmpty()) {
                    throw new ResourceException(UTIL.getString("no_keystore"));
                }
                if (InfinispanManagedConnectionFactory.this.keyStorePassword == null) {
                    throw new ResourceException(UTIL.getString("no_keystore_pass"));
                }
                if (InfinispanManagedConnectionFactory.this.trustStoreFileName == null && InfinispanManagedConnectionFactory.this.trustStorePassword.isEmpty()) {
                    throw new ResourceException(UTIL.getString("no_truststore"));
                }
                if (InfinispanManagedConnectionFactory.this.trustStorePassword == null) {
                    throw new ResourceException(UTIL.getString("no_truststore_pass"));
                }
                CallbackHandler callback = new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    }
                };
                builder.security().authentication().enable().saslMechanism("EXTERNAL").callbackHandler(callback).ssl().enable().keyStoreFileName(InfinispanManagedConnectionFactory.this.keyStoreFileName).keyStorePassword(InfinispanManagedConnectionFactory.this.keyStorePassword.toCharArray()).trustStoreFileName(InfinispanManagedConnectionFactory.this.trustStoreFileName).trustStorePassword(InfinispanManagedConnectionFactory.this.trustStorePassword.toCharArray());
            }
        }

        private boolean supportedSasl(String saslMechanism) {
            for (String supported : saslAllowed) {
                if (!supported.equals(saslMechanism)) continue;
                return true;
            }
            return false;
        }

        public void registerProtobufFile(ProtobufResource protobuf) throws TranslatorException {
            block5: {
                try {
                    if (protobuf != null) {
                        this.ctx.registerProtoFiles(FileDescriptorSource.fromString((String)protobuf.getIdentifier(), (String)protobuf.getContents()));
                        RemoteCache metadataCache = this.cacheManager.getCache("___protobuf_metadata");
                        if (metadataCache != null) {
                            String protoSchemaIdent;
                            metadataCache.put((Object)protobuf.getIdentifier(), (Object)protobuf.getContents());
                            String errors = (String)metadataCache.get((Object)".errors");
                            String string = protoSchemaIdent = protobuf.getIdentifier().startsWith("/") ? protobuf.getIdentifier().substring(1) : protobuf.getIdentifier();
                            if (errors != null && this.isProtoSchemaInErrors(protoSchemaIdent, errors)) {
                                throw new TranslatorException(UTIL.getString("proto_error", new Object[]{errors}));
                            }
                        }
                        break block5;
                    }
                    throw new TranslatorException(UTIL.getString("no_protobuf"));
                }
                catch (Throwable t) {
                    throw new TranslatorException(t);
                }
            }
        }

        private boolean isProtoSchemaInErrors(String ident, String errors) {
            for (String s : errors.split("\n")) {
                if (!s.trim().startsWith(ident)) continue;
                return true;
            }
            return false;
        }

        public InfinispanConnectionImpl getConnection() throws ResourceException {
            return new InfinispanConnectionImpl(this.cacheManager, this.scriptCacheManager, InfinispanManagedConnectionFactory.this.cacheName, this.ctx, this);
        }
    }
}

