/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.infinispan.hotrod;

import java.util.EnumSet;
import java.util.Map;
import javax.resource.ResourceException;
import org.infinispan.client.hotrod.AdminFlag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.teiid.infinispan.api.InfinispanConnection;
import org.teiid.infinispan.api.InfinispanDocument;
import org.teiid.infinispan.api.ProtobufResource;
import org.teiid.resource.adapter.infinispan.hotrod.InfinispanManagedConnectionFactory;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.translator.TranslatorException;

public class InfinispanConnectionImpl
extends BasicConnection
implements InfinispanConnection {
    private RemoteCacheManager cacheManager;
    private String cacheName;
    private BasicCache<?, ?> defaultCache;
    private SerializationContext ctx;
    private ThreadAwareMarshallerProvider marshallerProvider = new ThreadAwareMarshallerProvider();
    private InfinispanManagedConnectionFactory.InfinispanConnectionFactory icf;
    private RemoteCacheManager scriptManager;
    private String cacheTemplate;

    public InfinispanConnectionImpl(RemoteCacheManager manager, RemoteCacheManager scriptManager, String cacheName, SerializationContext ctx, InfinispanManagedConnectionFactory.InfinispanConnectionFactory icf, String cacheTemplate) throws ResourceException {
        this.cacheManager = manager;
        this.cacheName = cacheName;
        this.ctx = ctx;
        this.ctx.registerMarshallerProvider((SerializationContext.MarshallerProvider)this.marshallerProvider);
        this.icf = icf;
        try {
            this.defaultCache = this.cacheManager.getCache(this.cacheName);
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
        this.scriptManager = scriptManager;
        this.cacheTemplate = cacheTemplate;
    }

    public void registerProtobufFile(ProtobufResource protobuf) throws TranslatorException {
        this.icf.registerProtobufFile(protobuf);
    }

    public void close() throws ResourceException {
        this.ctx.unregisterMarshallerProvider((SerializationContext.MarshallerProvider)this.marshallerProvider);
    }

    public BasicCache getCache() throws TranslatorException {
        return this.defaultCache;
    }

    public <K, V> BasicCache<K, V> getCache(String cacheName, boolean createIfNotExists) throws TranslatorException {
        RemoteCache cache = this.cacheManager.getCache(cacheName);
        if (cache == null && createIfNotExists) {
            this.cacheManager.administration().createCache(cacheName, this.cacheTemplate, EnumSet.of(AdminFlag.PERSISTENT));
            cache = this.cacheManager.getCache(cacheName);
        }
        return cache;
    }

    public void registerMarshaller(BaseMarshaller<InfinispanDocument> marshaller) throws TranslatorException {
        ThreadAwareMarshallerProvider.setMarsheller(marshaller);
    }

    public void unRegisterMarshaller(BaseMarshaller<InfinispanDocument> marshaller) throws TranslatorException {
        ThreadAwareMarshallerProvider.setMarsheller(null);
    }

    public <T> T execute(String scriptName, Map<String, ?> params) {
        return (T)this.scriptManager.getCache().execute(scriptName, params);
    }

    public void registerScript(String scriptName, String script) {
        RemoteCache cache = this.scriptManager.getCache("___script_cache");
        if (cache.get((Object)scriptName) == null) {
            cache.put((Object)scriptName, (Object)script);
        }
    }

    static class ThreadAwareMarshallerProvider
    implements SerializationContext.MarshallerProvider {
        private static ThreadLocal<BaseMarshaller<?>> context = new ThreadLocal<BaseMarshaller<?>>(){

            @Override
            protected BaseMarshaller<?> initialValue() {
                return null;
            }
        };

        ThreadAwareMarshallerProvider() {
        }

        public static void setMarsheller(BaseMarshaller<?> marshaller) {
            context.set(marshaller);
        }

        public BaseMarshaller<?> getMarshaller(String typeName) {
            BaseMarshaller<?> m = context.get();
            if (m != null && typeName.equals(m.getTypeName())) {
                return context.get();
            }
            return null;
        }

        public BaseMarshaller<?> getMarshaller(Class<?> javaClass) {
            BaseMarshaller<?> m = context.get();
            if (m != null && javaClass.isAssignableFrom(InfinispanDocument.class)) {
                return context.get();
            }
            return null;
        }
    }
}

