/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.mongodb;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.resource.ResourceException;
import org.teiid.core.BundleUtil;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.resource.spi.BasicConnection;

public class MongoDBConnectionImpl
extends BasicConnection
implements MongoDBConnection {
    static final BundleUtil UTIL = BundleUtil.getBundleUtil(MongoDBConnectionImpl.class);
    private MongoClient client;
    private String database;

    public MongoDBConnectionImpl(String database, List<ServerAddress> servers, MongoCredential credential, MongoClientOptions options) {
        this.client = credential == null ? new MongoClient(servers, options) : new MongoClient(servers, Arrays.asList(credential), options);
        this.database = database;
    }

    public MongoDBConnectionImpl(String database, MongoClientURI uri) throws UnknownHostException {
        this.database = database;
        if (uri.getDatabase() != null) {
            this.database = database;
        }
        this.client = new MongoClient(uri);
    }

    public DB getDatabase() {
        return this.client.getDB(this.database);
    }

    public void close() throws ResourceException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

