/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.simpledb;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.resource.adapter.simpledb.SimpleDBConnectionImpl;
import org.teiid.translator.simpledb.api.SimpleDBConnection;

public class SimpleDbAPIClassTest {
    @Mock
    AmazonSimpleDBClient client;
    SimpleDBConnectionImpl simpleDbApi;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        try {
            this.simpleDbApi = new SimpleDBConnectionImpl("test", "test");
        }
        catch (AmazonServiceException amazonServiceException) {
            // empty catch block
        }
        this.replaceField("client", this.simpleDbApi, this.client);
    }

    @Test
    public void getDomainsTest() throws Exception {
        ListDomainsResult listDomainResult = (ListDomainsResult)Mockito.mock(ListDomainsResult.class);
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add("Test");
        resultList.add("Test1");
        Mockito.when((Object)this.client.listDomains()).thenReturn((Object)listDomainResult);
        Mockito.when((Object)listDomainResult.getDomainNames()).thenReturn(resultList);
        Assert.assertEquals(resultList, (Object)this.simpleDbApi.getDomains());
    }

    @Test
    public void getAttributeNamesTest() throws Exception {
        DomainMetadataResult metadataResult = (DomainMetadataResult)Mockito.mock(DomainMetadataResult.class);
        final SelectResult result = (SelectResult)Mockito.mock(SelectResult.class);
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(new Item("1", Arrays.asList(new Attribute("c", "d"), new Attribute("a", "b"))));
        Mockito.stub((Object)result.getItems()).toReturn(items);
        Mockito.when((Object)metadataResult.getAttributeNameCount()).thenReturn((Object)2);
        Mockito.when((Object)this.client.select((SelectRequest)Mockito.any(SelectRequest.class))).thenAnswer((Answer)new Answer<SelectResult>(){

            public SelectResult answer(InvocationOnMock invocation) throws Throwable {
                Assert.assertEquals((Object)"SELECT * FROM `x`", (Object)((SelectRequest)invocation.getArguments()[0]).getSelectExpression());
                return result;
            }
        });
        Mockito.when((Object)this.client.domainMetadata((DomainMetadataRequest)Mockito.any(DomainMetadataRequest.class))).thenReturn((Object)metadataResult);
        Assert.assertEquals((Object)"c", (Object)((SimpleDBConnection.SimpleDBAttribute)this.simpleDbApi.getAttributeNames("x").iterator().next()).getName());
    }

    @Test
    public void testAddNullAttribute() throws Exception {
        ArrayList attributes = new ArrayList();
        this.simpleDbApi.addAttribute("x", null, attributes);
        Assert.assertNull((Object)((ReplaceableAttribute)attributes.get(0)).getValue());
    }

    private void replaceField(String fieldName, Object object, Object newFieldValue) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, newFieldValue);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

