/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.simpledb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeletableItem;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import com.amazonaws.services.simpledb.util.SimpleDBUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.api.SimpleDBConnection;
import org.teiid.translator.simpledb.api.SimpleDBDataTypeManager;

public class SimpleDBConnectionImpl
extends BasicConnection
implements SimpleDBConnection {
    private AmazonSimpleDBClient client;
    private List<String> domains;

    public SimpleDBConnectionImpl(String accessKey, String secretAccessKey) {
        this.client = new AmazonSimpleDBClient((AWSCredentials)new BasicAWSCredentials(accessKey, secretAccessKey));
    }

    public void close() throws ResourceException {
    }

    public void createDomain(String domainName) throws TranslatorException {
        try {
            this.client.createDomain(new CreateDomainRequest(domainName));
        }
        catch (AmazonServiceException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (AmazonClientException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void deleteDomain(String domainName) throws TranslatorException {
        try {
            this.client.deleteDomain(new DeleteDomainRequest(domainName));
            if (this.domains.contains(domainName)) {
                this.domains.remove(domainName);
            }
        }
        catch (AmazonServiceException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (AmazonClientException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public List<String> getDomains() throws TranslatorException {
        return this.client.listDomains().getDomainNames();
    }

    public Set<SimpleDBConnection.SimpleDBAttribute> getAttributeNames(String domainName) throws TranslatorException {
        DomainMetadataRequest domainMetadataRequest = new DomainMetadataRequest(domainName);
        DomainMetadataResult metadataResult = this.client.domainMetadata(domainMetadataRequest);
        int attributesCount = metadataResult.getAttributeNameCount();
        SelectResult selectResult = this.client.select(new SelectRequest("SELECT * FROM " + SimpleDBUtils.quoteName((String)domainName)));
        return this.getAttributeNamesFromSelectResult(selectResult, attributesCount);
    }

    public int performDelete(String domainName, String selectExpression) throws TranslatorException {
        try {
            ArrayList<DeletableItem> deleteItems = new ArrayList<DeletableItem>();
            int count = 0;
            String nextToken = null;
            do {
                SelectResult result = this.performSelect(selectExpression, nextToken);
                nextToken = result.getNextToken();
                for (Item item : result.getItems()) {
                    deleteItems.add(new DeletableItem(item.getName(), null));
                    if (++count % 25 != 0) continue;
                    BatchDeleteAttributesRequest request = new BatchDeleteAttributesRequest(domainName, deleteItems);
                    this.client.batchDeleteAttributes(request);
                    deleteItems.clear();
                }
                if (deleteItems.isEmpty()) continue;
                BatchDeleteAttributesRequest request = new BatchDeleteAttributesRequest(domainName, deleteItems);
                this.client.batchDeleteAttributes(request);
            } while (nextToken != null);
            return count;
        }
        catch (AmazonServiceException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (AmazonClientException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public SelectResult performSelect(String selectExpression, String nextToken) throws TranslatorException {
        try {
            SelectRequest selectRequest = new SelectRequest(selectExpression);
            if (nextToken != null) {
                selectRequest.setNextToken(nextToken);
            }
            selectRequest.setConsistentRead(Boolean.valueOf(true));
            return this.client.select(selectRequest);
        }
        catch (AmazonServiceException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (AmazonClientException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public int performUpdate(String domainName, Map<String, Object> updateAttributes, String selectExpression) throws TranslatorException {
        try {
            ArrayList<ReplaceableAttribute> attributes = new ArrayList<ReplaceableAttribute>();
            for (Map.Entry<String, Object> column : updateAttributes.entrySet()) {
                this.addAttribute(column.getKey(), column.getValue(), attributes);
            }
            ArrayList<ReplaceableItem> updateItems = new ArrayList<ReplaceableItem>();
            int count = 0;
            String nextToken = null;
            do {
                SelectResult result = this.performSelect(selectExpression, nextToken);
                nextToken = result.getNextToken();
                for (Item item : result.getItems()) {
                    updateItems.add(new ReplaceableItem(item.getName(), attributes));
                    if (++count % 25 != 0) continue;
                    this.executeBatch(domainName, updateItems);
                    updateItems.clear();
                }
                this.executeBatch(domainName, updateItems);
            } while (nextToken != null);
            return count;
        }
        catch (AmazonServiceException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (AmazonClientException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public int performInsert(String domainName, List<Column> columns, Iterator<? extends List<?>> valueList) throws TranslatorException {
        try {
            if (this.domains == null) {
                this.domains = this.getDomains();
            }
            if (!this.domains.contains(domainName)) {
                this.createDomain(domainName);
            }
            int count = 0;
            ArrayList<ReplaceableItem> insertItems = new ArrayList<ReplaceableItem>();
            while (valueList.hasNext()) {
                List<?> values = valueList.next();
                ArrayList<ReplaceableAttribute> attributes = new ArrayList<ReplaceableAttribute>();
                String itemName = null;
                for (int i = 0; i < columns.size(); ++i) {
                    Column column = columns.get(i);
                    if (SQLStringVisitor.getRecordName((AbstractMetadataRecord)column).equals("itemName()")) {
                        itemName = (String)values.get(i);
                        continue;
                    }
                    this.addAttribute(SQLStringVisitor.getRecordName((AbstractMetadataRecord)column), SimpleDBDataTypeManager.convertToSimpleDBType(values.get(i), (Class)column.getJavaType()), attributes);
                }
                if (itemName == null) {
                    throw new TranslatorException("ItemName() column value is not specified, it can not be null. Please provide a value.");
                }
                insertItems.add(new ReplaceableItem(itemName, attributes));
                if (++count % 25 != 0) continue;
                this.executeBatch(domainName, insertItems);
                insertItems.clear();
            }
            this.executeBatch(domainName, insertItems);
            return count;
        }
        catch (AmazonServiceException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (AmazonClientException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void executeBatch(String domainName, List<ReplaceableItem> insertItems) {
        if (!insertItems.isEmpty()) {
            BatchPutAttributesRequest request = new BatchPutAttributesRequest(domainName, insertItems);
            this.client.batchPutAttributes(request);
        }
    }

    void addAttribute(String name, Object value, List<ReplaceableAttribute> attributes) {
        if (value != null && value.getClass().isArray()) {
            String[] values = (String[])value;
            for (int i = 0; i < values.length; ++i) {
                this.addAttribute(name, values[i], attributes);
            }
        } else {
            ReplaceableAttribute attribute = new ReplaceableAttribute();
            attribute.setName(name);
            attribute.setReplace(Boolean.valueOf(true));
            attribute.setValue((String)value);
            attributes.add(attribute);
        }
    }

    private Set<SimpleDBConnection.SimpleDBAttribute> getAttributeNamesFromSelectResult(SelectResult selectResult, int attributesCount) {
        LinkedHashSet<SimpleDBConnection.SimpleDBAttribute> attributes = new LinkedHashSet<SimpleDBConnection.SimpleDBAttribute>();
        Iterator itemsIterator = selectResult.getItems().iterator();
        while (attributes.size() < attributesCount) {
            Item item = (Item)itemsIterator.next();
            Map<String, List<String>> valueMap = this.createAttributeMap(item.getAttributes());
            Iterator<String> iterator = valueMap.keySet().iterator();
            while (iterator.hasNext()) {
                String attributeName;
                List<String> values = valueMap.get(attributeName = iterator.next());
                attributes.add(new SimpleDBConnection.SimpleDBAttribute(attributeName, values.size() > 1));
            }
        }
        return attributes;
    }

    private Map<String, List<String>> createAttributeMap(List<Attribute> attributes) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (Attribute attribute : attributes) {
            if (map.get(attribute.getName()) == null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(attribute.getValue());
                map.put(attribute.getName(), list);
                continue;
            }
            ((List)map.get(attribute.getName())).add(attribute.getValue());
        }
        return map;
    }
}

