/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.solr;

import java.io.IOException;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.SolrHttpRequestRetryHandler;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.teiid.resource.adapter.solr.SolrManagedConnectionFactory;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.resource.spi.ConnectionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.solr.SolrConnection;

public class SolrConnectionImpl
extends BasicConnection
implements SolrConnection {
    private HttpSolrClient server;
    private String coreName;

    public SolrConnectionImpl(SolrManagedConnectionFactory config) {
        String url = config.getUrl();
        if (!url.endsWith("/")) {
            url = config.getUrl() + "/";
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        String userName = config.getAuthUserName();
        String password = config.getAuthPassword();
        Subject subject = ConnectionContext.getSubject();
        if (subject != null) {
            userName = ConnectionContext.getUserName((Subject)subject, (BasicManagedConnectionFactory)config, (String)userName);
            password = ConnectionContext.getPassword((Subject)subject, (BasicManagedConnectionFactory)config, (String)userName, (String)password);
        }
        if (userName != null) {
            params.set("httpBasicAuthUser", new String[]{userName});
            params.set("httpBasicAuthPassword", new String[]{password});
        }
        url = url + config.getCoreName();
        this.server = new HttpSolrClient.Builder().withInvariantParams(params).build();
        if (config.getSoTimeout() != null) {
            this.server.setSoTimeout(config.getSoTimeout().intValue());
        }
        if (config.getConnTimeout() != null) {
            this.server.setConnectionTimeout(config.getConnTimeout().intValue());
        }
        if (config.getMaxConns() != null) {
            this.server.setMaxTotalConnections(config.getMaxConns().intValue());
        }
        if (config.getAllowCompression() != null) {
            this.server.setAllowCompression(config.getAllowCompression().booleanValue());
        }
        if (config.getMaxRetries() != null) {
            ((DefaultHttpClient)this.server.getHttpClient()).setHttpRequestRetryHandler((HttpRequestRetryHandler)new SolrHttpRequestRetryHandler(config.getMaxRetries().intValue()));
        }
        this.coreName = config.getCoreName();
    }

    public void close() throws ResourceException {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                throw new ResourceException((Throwable)e);
            }
        }
    }

    public boolean isAlive() {
        try {
            this.server.ping();
        }
        catch (SolrServerException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public QueryResponse query(SolrQuery params) throws TranslatorException {
        try {
            return this.server.query((SolrParams)params);
        }
        catch (SolrServerException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public UpdateResponse update(UpdateRequest request) throws TranslatorException {
        try {
            request.setCommitWithin(-1);
            request.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, false);
            return (UpdateResponse)request.process((SolrClient)this.server);
        }
        catch (SolrServerException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public LukeResponse metadata(LukeRequest request) throws TranslatorException {
        try {
            return (LukeResponse)request.process((SolrClient)this.server);
        }
        catch (SolrServerException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public String getCoreName() {
        return this.coreName;
    }
}

