/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.document;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Document {
    private String name;
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private Map<String, List<Document>> children = new LinkedHashMap<String, List<Document>>();
    private boolean array;
    private Document parent;

    public Document() {
    }

    public Document(String name, boolean array, Document parent) {
        this.name = name;
        this.parent = parent;
        this.array = array;
    }

    public boolean isArray() {
        return this.array;
    }

    static List<Map<String, Object>> crossjoinWith(List<Map<String, Object>> left, List<? extends Document> rightDocuments) {
        ArrayList<Map<String, Object>> joined = new ArrayList<Map<String, Object>>();
        for (Document document : rightDocuments) {
            List<Map<String, Object>> rightRows = document.flatten();
            for (Map<String, Object> outer : left) {
                for (Map<String, Object> inner : rightRows) {
                    LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                    row.putAll(outer);
                    row.putAll(inner);
                    joined.add(row);
                }
            }
        }
        return joined;
    }

    public List<Map<String, Object>> flatten() {
        List<Map<String, Object>> joined = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        if (this.properties != null) {
            row.putAll(this.properties);
        }
        joined.add(row);
        if (this.children != null && !this.children.isEmpty()) {
            for (List<Document> childDoc : this.children.values()) {
                joined = Document.crossjoinWith(joined, childDoc);
            }
        }
        return joined;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, List<Document>> getChildren() {
        return this.children;
    }

    public List<? extends Document> getChildDocuments(String path) {
        if (this.children != null) {
            int index = path.indexOf(47);
            if (index != -1) {
                String parentName = path.substring(0, index);
                if (parentName.equals(this.name)) {
                    return this.children.get(path.substring(index + 1));
                }
                return this.parent.getChildDocuments(parentName);
            }
            List<Document> children = this.children.get(path);
            if (children == null && this.parent != null) {
                children = this.parent.getChildDocuments(path);
            }
            return children;
        }
        return null;
    }

    private static String name(String s1, String s2) {
        if (s1 != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(s1).append("/").append(s2);
            return sb.toString();
        }
        return s2;
    }

    public String getName() {
        if (this.parent != null) {
            return Document.name(this.parent.getName(), this.name);
        }
        return this.name;
    }

    public void addProperty(String key, Object value) {
        if (this.parent == null) {
            this.properties.put(key, value);
        } else {
            this.properties.put(Document.name(this.getName(), key), value);
        }
    }

    public void addArrayProperty(String key, Object value) {
        String propkey;
        ArrayList<Object> propValue;
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        if ((propValue = (ArrayList<Object>)this.properties.get(propkey = this.parent == null ? key : Document.name(this.getName(), key))) == null) {
            propValue = new ArrayList<Object>();
            propValue.add(value);
        } else {
            propValue.add(value);
        }
        this.properties.put(propkey, propValue);
    }

    public void addChildDocuments(String path, List<Document> child) {
        this.children.put(path, child);
    }

    public List<Document> addChildDocument(String path, Document child) {
        if (this.children == null) {
            this.children = new LinkedHashMap<String, List<Document>>();
        }
        if (this.children.get(path) == null) {
            this.children.put(path, new ArrayList());
        }
        this.children.get(path).add(child);
        return this.children.get(path);
    }

    public String toString() {
        return this.name;
    }

    public Document getParent() {
        return this.parent;
    }

    public String getSimpleName() {
        return this.name;
    }
}

