/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.file.VirtualFile;

public class JavaVirtualFile
implements VirtualFile {
    private final File f;

    public JavaVirtualFile(File f) {
        this.f = f;
    }

    @Override
    public String getName() {
        return this.f.getName();
    }

    @Override
    public long getLastModified() {
        return this.f.lastModified();
    }

    @Override
    public long getCreationTime() {
        try {
            Map<String, Object> attributes = Files.readAttributes(this.f.toPath(), "creationTime", new LinkOption[0]);
            return ((FileTime)attributes.get("creationTime")).toMillis();
        }
        catch (IOException iOException) {
            return this.f.lastModified();
        }
    }

    @Override
    public long getSize() {
        return this.f.length();
    }

    @Override
    public InputStream openInputStream(boolean lock) throws IOException {
        FileInputStream fis = new FileInputStream(this.f);
        if (lock) {
            fis.getChannel().tryLock(0L, Long.MAX_VALUE, true);
        }
        return fis;
    }

    @Override
    public OutputStream openOutputStream(boolean lock) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.f);
        if (lock) {
            fos.getChannel().lock();
        }
        return fos;
    }

    @Override
    public InputStreamFactory createInputStreamFactory() {
        return new InputStreamFactory.FileInputStreamFactory(this.f);
    }

    public static VirtualFile[] getFiles(String location, File datafile) {
        if (datafile.isDirectory()) {
            return JavaVirtualFile.convert(datafile.listFiles());
        }
        if (datafile.exists()) {
            return new VirtualFile[]{new JavaVirtualFile(datafile)};
        }
        File parentDir = datafile.getParentFile();
        if (parentDir == null || !parentDir.exists()) {
            return null;
        }
        if (location.contains("*")) {
            location = location.replaceAll("\\\\", "\\\\\\\\");
            location = location.replaceAll("\\?", "\\\\?");
            location = location.replaceAll("\\[", "\\\\[");
            location = location.replaceAll("\\{", "\\\\{");
            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + location);
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && matcher.matches(FileSystems.getDefault().getPath(pathname.getName(), new String[0]));
                }
            };
            return JavaVirtualFile.convert(parentDir.listFiles(fileFilter));
        }
        return null;
    }

    public static VirtualFile[] convert(File[] files) {
        VirtualFile[] result = new VirtualFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new JavaVirtualFile(files[i]);
        }
        return result;
    }
}

