/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.file.ftp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.jboss.vfs.VFS;
import org.jboss.vfs.spi.FileSystem;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.StringUtil;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.file.ftp.FtpConfiguration;
import org.teiid.file.ftp.FtpFileSystem;
import org.teiid.translator.TranslatorException;

public class FtpFileConnection
implements VirtualFileConnection {
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(FtpFileConnection.class);
    private org.jboss.vfs.VirtualFile mountPoint;
    private Map<String, String> fileMapping;
    private Closeable closeable;
    private final FTPClient client;

    public FtpFileConnection(FtpConfiguration config) throws TranslatorException {
        this.client = this.createFtpClient(config);
        Map map = (Map)StringUtil.valueOf((String)config.getFileMapping(), Map.class);
        this.fileMapping = map == null ? Collections.emptyMap() : map;
        String pathname = config.getParentDirectory();
        try {
            if (this.client.cwd(pathname) != 250) {
                throw new TranslatorException(UTIL.getString("parentdirectory_not_set"));
            }
            this.client.changeWorkingDirectory(pathname);
            this.mountPoint = VFS.getChild((String)pathname);
            this.closeable = VFS.mount((org.jboss.vfs.VirtualFile)this.mountPoint, (FileSystem)new FtpFileSystem(this.client));
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e, UTIL.getString("vfs_mount_error", new Object[]{pathname}));
        }
    }

    FTPClient getClient() {
        return this.client;
    }

    public void close() throws TranslatorException {
        try {
            this.closeable.close();
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    @Override
    public VirtualFile[] getFiles(String pattern) {
        org.jboss.vfs.VirtualFile file = this.getFile(pattern);
        if (file.exists()) {
            return new VirtualFile[]{new JBossVirtualFile(file)};
        }
        return null;
    }

    public org.jboss.vfs.VirtualFile getFile(String path) {
        if (path == null) {
            return this.mountPoint;
        }
        String altPath = this.fileMapping.get(path);
        if (altPath != null) {
            path = altPath;
        }
        return this.mountPoint.getChild(path);
    }

    @Override
    public void add(InputStream in, String path) throws TranslatorException {
        try {
            this.client.storeFile(path, in);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e, UTIL.getString("ftp_failed_write", new Object[]{path, this.client.getReplyString()}));
        }
    }

    @Override
    public boolean remove(String path) {
        return this.mountPoint.getChild(path).delete();
    }

    private FTPClient createFtpClient(FtpConfiguration config) throws TranslatorException {
        FTPClient client = this.createClientInstance(config);
        try {
            this.beforeConnect(client, config);
            client.connect(config.getHost(), config.getPort().intValue());
            if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                throw new TranslatorException(UTIL.getString("ftp_connect_failed", new Object[]{config.getHost(), config.getPort()}));
            }
            if (!client.login(config.getUsername(), config.getPassword())) {
                throw new IllegalStateException(UTIL.getString("ftp_login_failed", new Object[]{client.getReplyString()}));
            }
            this.afterConnect(client, config);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
        return client;
    }

    private FTPClient createClientInstance(FtpConfiguration config) {
        if (config.getIsFtps().booleanValue()) {
            if (config.getProtocol() != null) {
                return new FTPSClient(config.getProtocol(), config.isImplicit().booleanValue());
            }
            return new FTPSClient(config.isImplicit().booleanValue());
        }
        return new FTPClient();
    }

    private void beforeConnect(FTPClient client, FtpConfiguration config) throws IOException {
        if (config.getConnectTimeout() != null) {
            client.setConnectTimeout(config.getConnectTimeout().intValue());
        }
        if (config.getDefaultTimeout() != null) {
            client.setDefaultTimeout(config.getDefaultTimeout().intValue());
        }
        if (config.getDataTimeout() != null) {
            client.setDataTimeout(config.getDataTimeout().intValue());
        }
        client.setControlEncoding(config.getControlEncoding());
        if (config.getIsFtps().booleanValue()) {
            FTPSClient ftpsClient = (FTPSClient)client;
            ftpsClient.execPBSZ(0L);
            ftpsClient.execPROT(config.getExecProt());
        }
    }

    private void afterConnect(FTPClient client, FtpConfiguration config) throws IOException {
        if (config.getParentDirectory() == null) {
            throw new IOException(UTIL.getString("parentdirectory_not_set"));
        }
        if (!client.changeWorkingDirectory(config.getParentDirectory())) {
            throw new IOException(UTIL.getString("ftp_dir_not_exist", new Object[]{config.getParentDirectory()}));
        }
        switch (config.getClientMode()) {
            case 0: {
                client.enterLocalActiveMode();
                break;
            }
            case 2: {
                client.enterLocalPassiveMode();
                break;
            }
        }
        client.setFileType(config.getFileType().intValue());
        client.setBufferSize(config.getBufferSize().intValue());
        if (config.getIsFtps().booleanValue()) {
            FTPSClient ftpsClient = (FTPSClient)client;
            if (config.getAuthValue() != null) {
                ftpsClient.setAuthValue(config.getAuthValue());
            }
            if (config.getTrustManager() != null) {
                ftpsClient.setTrustManager(config.getTrustManager());
            }
            if (config.getSupportedCipherSuites() != null) {
                ftpsClient.setEnabledCipherSuites(config.getSupportedCipherSuites());
            }
            if (config.getSupportedProtocols() != null) {
                ftpsClient.setEnabledProtocols(config.getSupportedProtocols());
            }
            if (config.getSessionCreation() != null) {
                ftpsClient.setEnabledSessionCreation(config.getSessionCreation().booleanValue());
            }
            if (config.getUseClientMode() != null) {
                ftpsClient.setUseClientMode(config.getUseClientMode().booleanValue());
            }
            if (config.getKeyManager() != null) {
                ftpsClient.setKeyManager(config.getKeyManager());
            }
            if (config.getNeedClientAuth() != null) {
                ftpsClient.setNeedClientAuth(config.getNeedClientAuth().booleanValue());
            }
            if (config.getWantsClientAuth() != null) {
                ftpsClient.setWantClientAuth(config.getWantsClientAuth().booleanValue());
            }
        }
    }

    static class JBossVirtualFile
    implements VirtualFile {
        private org.jboss.vfs.VirtualFile file;

        public JBossVirtualFile(org.jboss.vfs.VirtualFile file) {
            this.file = file;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public InputStreamFactory createInputStreamFactory() {
            return new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return file.openStream();
                }
            };
        }

        @Override
        public InputStream openInputStream(boolean lock) throws IOException {
            return this.file.openStream();
        }

        @Override
        public OutputStream openOutputStream(boolean lock) throws IOException {
            throw new IOException("not supported");
        }

        @Override
        public long getLastModified() {
            return this.file.getLastModified();
        }

        @Override
        public long getCreationTime() {
            return this.file.getLastModified();
        }

        @Override
        public long getSize() {
            return this.file.getSize();
        }
    }
}

