/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.file.ftp;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.file.ftp.FtpFileConnection;
import org.teiid.file.ftp.FtpFileSystem;
import org.teiid.file.ftp.TestFtpFileConnection;

@Ignore(value="Ignore due to this test depend on remote ftp server and reference configuration")
public class TestFtpFileSystem {
    @BeforeClass
    public static void sample() throws Exception {
        FtpFileConnection conn = TestFtpFileConnection.sample();
        VirtualFile mountPoint = VFS.getChild((String)"/home/kylin/vsftpd");
        VFS.mount((VirtualFile)mountPoint, (FileSystem)new FtpFileSystem(conn.getClient()));
    }

    @Test
    public void testGetFile() throws Exception {
        File file = VFS.getChild((String)"/home/kylin/vsftpd/not-exist.txt").getPhysicalFile();
        Assert.assertNull((Object)file);
    }

    @Test
    public void testOpenStream() throws Exception {
        InputStream in = VFS.getChild((String)"/home/kylin/vsftpd/not-exist.txt").openStream();
        Assert.assertNull((Object)in);
        in = VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").openStream();
        Assert.assertNotNull((Object)in);
        in.close();
    }

    @Test
    public void testDelete() throws Exception {
        this.writeFile(new File("pom.xml").getAbsolutePath());
        VirtualFile file = VFS.getChild((String)"/home/kylin/vsftpd/pom.xml");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.delete());
        Assert.assertFalse((boolean)file.exists());
    }

    private void writeFile(String path) throws Exception {
        VirtualFile file = VFS.getChild((String)path);
        FtpFileConnection conn = TestFtpFileConnection.sample();
        FTPClient client = conn.getClient();
        client.storeFile(file.getName(), file.openStream());
        client.disconnect();
    }

    @Test
    public void testGetSize() {
        Assert.assertEquals((long)-1L, (long)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").getSize());
        Assert.assertEquals((long)-1L, (long)VFS.getChild((String)"/home/kylin/vsftpd/sub").getSize());
    }

    @Test
    public void testGetLastModified() {
        Assert.assertEquals((long)1480314470000L, (long)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").getLastModified());
        Assert.assertEquals((long)-1L, (long)VFS.getChild((String)"/home/kylin/vsftpd/sub").getLastModified());
    }

    @Test
    public void testExists() {
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").exists());
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price1.txt").exists());
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/sub").exists());
    }

    @Test
    public void testIsFile() {
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").isFile());
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price1.txt").isFile());
        Assert.assertFalse((boolean)VFS.getChild((String)"/home/kylin/vsftpd/sub").isFile());
    }

    @Test
    public void testIsDirectory() {
        Assert.assertFalse((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price.txt").isDirectory());
        Assert.assertFalse((boolean)VFS.getChild((String)"/home/kylin/vsftpd/marketdata-price1.txt").isDirectory());
        Assert.assertTrue((boolean)VFS.getChild((String)"/home/kylin/vsftpd/sub").isDirectory());
    }

    @Test
    public void testNamelist() {
        Assert.assertTrue((VFS.getChild((String)"/home/kylin/vsftpd").getChildren().size() > 0 ? 1 : 0) != 0);
    }
}

