/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.file.ftp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSigner;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;

public class FtpFileSystem
implements FileSystem {
    private FTPClient client;

    public FtpFileSystem(FTPClient ftpClient) {
        this.client = ftpClient;
    }

    public File getFile(VirtualFile mountPoint, VirtualFile target) throws IOException {
        throw new IOException();
    }

    public InputStream openInputStream(VirtualFile mountPoint, VirtualFile target) throws IOException {
        return this.client.retrieveFileStream(target.getName());
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean delete(VirtualFile mountPoint, VirtualFile target) {
        try {
            return this.client.deleteFile(target.getName());
        }
        catch (IOException e) {
            throw new FtpOperationException(e);
        }
    }

    public long getSize(VirtualFile mountPoint, VirtualFile target) {
        try {
            FTPFile file = this.client.mlistFile(target.getName());
            return file != null ? file.getSize() : -1L;
        }
        catch (IOException e) {
            throw new FtpOperationException(e);
        }
    }

    public long getLastModified(VirtualFile mountPoint, VirtualFile target) {
        try {
            FTPFile file = this.client.mdtmFile(target.getName());
            return file != null ? file.getTimestamp().getTimeInMillis() : -1L;
        }
        catch (IOException e) {
            throw new FtpOperationException(e);
        }
    }

    public boolean exists(VirtualFile mountPoint, VirtualFile target) {
        return this.isFile(mountPoint, target) || this.isDirectory(mountPoint, target);
    }

    public boolean isFile(VirtualFile mountPoint, VirtualFile target) {
        InputStream in = null;
        try {
            in = this.openInputStream(mountPoint, target);
            int returnCode = this.client.getReplyCode();
            if (in == null || returnCode == 550) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new FtpOperationException(e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                    this.client.completePendingCommand();
                }
                catch (IOException e) {
                    throw new FtpOperationException(e);
                }
            }
        }
    }

    public boolean isDirectory(VirtualFile mountPoint, VirtualFile target) {
        try {
            if (this.client.cwd(target.getPathName()) == 250) {
                return true;
            }
        }
        catch (IOException e) {
            throw new FtpOperationException(e);
        }
        return false;
    }

    public List<String> getDirectoryEntries(VirtualFile mountPoint, VirtualFile target) {
        try {
            return Arrays.asList(this.client.listNames(target.getPathName()));
        }
        catch (IOException e) {
            throw new FtpOperationException(e);
        }
    }

    public CodeSigner[] getCodeSigners(VirtualFile mountPoint, VirtualFile target) {
        return null;
    }

    public void close() throws IOException {
        this.client.disconnect();
    }

    public File getMountSource() {
        return null;
    }

    public URI getRootURI() throws URISyntaxException {
        try {
            return new URI("ftp", this.client.printWorkingDirectory() + "!/", null);
        }
        catch (IOException e) {
            throw new FtpOperationException(e);
        }
    }

    private static class FtpOperationException
    extends RuntimeException {
        private static final long serialVersionUID = 2112491370833353846L;

        FtpOperationException(Throwable cause) {
            super(cause);
        }
    }
}

