/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.file.ftp;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.file.ftp.FtpConfiguration;
import org.teiid.file.ftp.FtpFileConnection;
import org.teiid.translator.TranslatorException;

@Ignore(value="Ignore due to this test depend on remote ftp server and reference configuration")
public class TestFtpFileConnection {
    static FtpFileConnection sample() throws Exception {
        FtpConfiguration mcf = new FtpConfiguration(){

            public String getParentDirectory() {
                return "/home/kylin/vsftpd";
            }

            public String getUsername() {
                return "kylin";
            }

            public String getHost() {
                return "10.66.192.120";
            }

            public String getPassword() {
                return "redhat";
            }
        };
        return new FtpFileConnection(mcf);
    }

    @Test
    public void testGetFile() throws Exception {
        FtpFileConnection conn = TestFtpFileConnection.sample();
        VirtualFile file = conn.getFile("marketdata-price.txt");
        Assert.assertNotNull((Object)file.openStream());
        file = conn.getFile("marketdata-price1.txt");
        Assert.assertNotNull((Object)file.openStream());
        conn.close();
    }

    @Test
    public void testPatternFilter() {
        String[] array;
        String fileName = "*.txt";
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:*" + fileName);
        for (String name : array = new String[]{"/path/to/marketdata-price.txt", "marketdata-price1.txt"}) {
            Assert.assertTrue((boolean)matcher.matches(Paths.get(name, new String[0])));
        }
    }

    @Test(expected=TranslatorException.class)
    public void testGetFiles() throws Exception {
        FtpFileConnection conn = TestFtpFileConnection.sample();
        conn.getFiles("*.txt");
    }

    @Test
    public void testAdd() throws Exception {
        FtpFileConnection conn = TestFtpFileConnection.sample();
        VirtualFile file = conn.getFile("pom.xml");
        Assert.assertFalse((boolean)file.exists());
        VirtualFile pom = VFS.getChild((String)new File("pom.xml").getAbsolutePath());
        conn.add(pom.openStream(), pom.getName());
        Assert.assertTrue((boolean)file.exists());
        conn.close();
        conn = TestFtpFileConnection.sample();
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertNotNull((Object)file.openStream());
        conn.close();
    }

    @Test
    public void testRemove() throws Exception {
        FtpFileConnection conn = TestFtpFileConnection.sample();
        VirtualFile pom = VFS.getChild((String)new File("pom.xml").getAbsolutePath());
        VirtualFile file = conn.getFile("pom.xml");
        conn.add(pom.openStream(), pom.getName());
        Assert.assertTrue((boolean)file.exists());
        conn.remove("pom.xml");
        Assert.assertFalse((boolean)file.exists());
        conn.close();
    }
}

