/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.file.VirtualFile;

public class JavaVirtualFile
implements VirtualFile {
    private final File f;
    private final String path;

    public JavaVirtualFile(File f) {
        this.f = f;
        this.path = f.getPath();
    }

    public JavaVirtualFile(File f, String path) {
        this.f = f;
        this.path = path;
    }

    @Override
    public String getName() {
        return this.f.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.f.isDirectory();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public long getLastModified() {
        return this.f.lastModified();
    }

    @Override
    public long getCreationTime() {
        try {
            Map<String, Object> attributes = Files.readAttributes(this.f.toPath(), "creationTime", new LinkOption[0]);
            return ((FileTime)attributes.get("creationTime")).toMillis();
        }
        catch (IOException iOException) {
            return this.f.lastModified();
        }
    }

    @Override
    public long getSize() {
        return this.f.length();
    }

    @Override
    public InputStream openInputStream(boolean lock) throws IOException {
        FileInputStream fis = new FileInputStream(this.f);
        if (lock) {
            try {
                fis.getChannel().tryLock(0L, Long.MAX_VALUE, true);
            }
            catch (OverlappingFileLockException e) {
                fis.getChannel().lock();
            }
        }
        return fis;
    }

    @Override
    public OutputStream openOutputStream(boolean lock) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.f);
        if (lock) {
            fos.getChannel().lock();
        }
        return fos;
    }

    @Override
    public InputStreamFactory createInputStreamFactory() {
        return new InputStreamFactory.FileInputStreamFactory(this.f);
    }

    @Override
    public InputStreamFactory.StorageMode getStorageMode() {
        return InputStreamFactory.StorageMode.PERSISTENT;
    }
}

