/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.hdfs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.file.VirtualFile;
import org.teiid.hdfs.HdfsConfiguration;
import org.teiid.hdfs.HdfsConnection;
import org.teiid.hdfs.HdfsConnectionFactory;
import org.teiid.translator.TranslatorException;

@Ignore
public class TestHdfsConnection {
    private static HdfsConnection CONNECTION;

    @BeforeClass
    public static void setUp() throws Exception {
        CONNECTION = new HdfsConnection(new HdfsConnectionFactory(new HdfsConfiguration(){

            public String getResourcePath() {
                return null;
            }

            public String getFsUri() {
                return "hdfs://localhost:9000";
            }
        }));
    }

    @Test
    public void testAdd() throws TranslatorException {
        this.addFile("folder1/hello");
        VirtualFile[] virtualFiles = CONNECTION.getFiles("folder1/hello");
        Assert.assertEquals((String)"The test fails", (Object)"hello", (Object)virtualFiles[0].getName());
    }

    private void addFile(String name) throws TranslatorException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("hello world".getBytes(Charset.forName("UTF-8")));
        CONNECTION.add((InputStream)inputStream, name);
    }

    @Test
    public void testDeleteFile() throws TranslatorException {
        String file = "main/hello";
        Assert.assertFalse((boolean)CONNECTION.remove(file));
        this.addFile(file);
        Assert.assertTrue((boolean)CONNECTION.remove(file));
        VirtualFile[] virtualFiles = CONNECTION.getFiles(file);
        Assert.assertNull((Object)virtualFiles);
    }

    @Test
    public void testSearch() throws TranslatorException {
        VirtualFile[] virtualFiles = CONNECTION.getFiles("/user/aditya/*.txt");
        Assert.assertNull((Object)virtualFiles);
        this.addFile("/user/aditya/afile.txt");
        this.addFile("/user/aditya/bfile.txt");
        this.addFile("/user/aditya/otherfile");
        virtualFiles = CONNECTION.getFiles("/user/aditya/*.txt");
        Assert.assertEquals((long)2L, (long)virtualFiles.length);
        virtualFiles = CONNECTION.getFiles("/user/aditya/");
        Assert.assertEquals((long)3L, (long)virtualFiles.length);
    }

    @AfterClass
    public static void teardown() throws Exception {
        if (CONNECTION != null) {
            CONNECTION.close();
        }
    }
}

