/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.teiid.hdfs.HdfsConfiguration;
import org.teiid.hdfs.HdfsConnection;
import org.teiid.logging.LogManager;
import org.teiid.translator.TranslatorException;

public class HdfsConnectionFactory
implements Closeable {
    private HdfsConfiguration config;
    private volatile FileSystem fileSystem;

    public HdfsConnectionFactory(HdfsConfiguration config) {
        this.config = config;
        try {
            this.getFileSystem();
        }
        catch (TranslatorException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Could not make initial connection to hdfs", (Object)((Object)e));
        }
    }

    protected FileSystem createFileSystem(String fsUri, String resourcePath) throws TranslatorException {
        Configuration configuration = new Configuration();
        if (resourcePath != null) {
            boolean classpath = false;
            try (InputStream is = HdfsConnection.class.getResourceAsStream(resourcePath);){
                classpath = is != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (classpath) {
                configuration.addResource(resourcePath);
            } else {
                configuration.addResource(new Path(resourcePath));
            }
        }
        try {
            return FileSystem.get((URI)new URI(fsUri), (Configuration)configuration);
        }
        catch (IOException | URISyntaxException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getFileSystem() throws TranslatorException {
        if (this.fileSystem == null) {
            HdfsConnectionFactory hdfsConnectionFactory = this;
            synchronized (hdfsConnectionFactory) {
                if (this.fileSystem == null) {
                    this.fileSystem = this.createFileSystem(this.config.getFsUri(), this.config.getResourcePath());
                }
            }
        }
        return this.fileSystem;
    }
}

