/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.teiid.file.VirtualFile;

public class HdfsVirtualFile
implements VirtualFile {
    private final FileSystem fileSystem;
    private final FileStatus fileStatus;

    public HdfsVirtualFile(FileSystem fileSystem, FileStatus fileStatus) {
        this.fileSystem = fileSystem;
        this.fileStatus = fileStatus;
    }

    public String getName() {
        return this.fileStatus.getPath().getName();
    }

    public InputStream openInputStream(boolean lock) throws IOException {
        return this.fileSystem.open(this.fileStatus.getPath());
    }

    public OutputStream openOutputStream(boolean lock) throws IOException {
        return this.fileSystem.create(this.fileStatus.getPath());
    }

    public long getLastModified() {
        return this.fileStatus.getModificationTime();
    }

    public long getCreationTime() {
        return this.fileStatus.getModificationTime();
    }

    public long getSize() {
        return this.fileStatus.getBlockSize();
    }
}

