/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.IOUtils;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.hdfs.HdfsConnectionFactory;
import org.teiid.hdfs.HdfsVirtualFile;
import org.teiid.translator.TranslatorException;

public class HdfsConnection
implements VirtualFileConnection {
    private final FileSystem fileSystem;

    public HdfsConnection(HdfsConnectionFactory connectionFactory) throws TranslatorException {
        this.fileSystem = connectionFactory.getFileSystem();
    }

    public HdfsConnection(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public VirtualFile[] getFiles(String location) throws TranslatorException {
        Path path = new Path(location);
        Path parentPath = path.getParent();
        try {
            FileStatus fileStatus = this.fileSystem.getFileStatus(path);
            if (fileStatus.isDirectory()) {
                return this.convert(path);
            }
            if (fileStatus.isFile()) {
                return new VirtualFile[]{new HdfsVirtualFile(this.fileSystem, fileStatus)};
            }
        }
        catch (FileNotFoundException fileStatus) {
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
        if (location.contains("*") && parentPath != null) {
            location = location.replaceAll("\\\\", "\\\\\\\\");
            location = location.replaceAll("\\?", "\\\\?");
            location = location.replaceAll("\\[", "\\\\[");
            location = location.replaceAll("\\{", "\\\\{");
            try {
                if (this.fileSystem.getFileStatus(parentPath) == null) {
                    return null;
                }
                FileStatus[] fileStatuses = this.fileSystem.globStatus(new Path(location));
                Vector<HdfsVirtualFile> hdfsVirtualFiles = new Vector<HdfsVirtualFile>();
                for (int i = 0; i < fileStatuses.length; ++i) {
                    if (!fileStatuses[i].isFile()) continue;
                    hdfsVirtualFiles.add(new HdfsVirtualFile(this.fileSystem, fileStatuses[i]));
                }
                VirtualFile[] virtualFiles = new VirtualFile[hdfsVirtualFiles.size()];
                for (int i = 0; i < hdfsVirtualFiles.size(); ++i) {
                    virtualFiles[i] = (VirtualFile)hdfsVirtualFiles.get(i);
                }
                return virtualFiles;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        return null;
    }

    private VirtualFile[] convert(Path path) throws IOException {
        RemoteIterator fileStatusRemoteIterator = this.fileSystem.listFiles(path, false);
        Vector<HdfsVirtualFile> hdfsVirtualFiles = new Vector<HdfsVirtualFile>();
        while (fileStatusRemoteIterator.hasNext()) {
            hdfsVirtualFiles.add(new HdfsVirtualFile(this.fileSystem, (FileStatus)fileStatusRemoteIterator.next()));
        }
        VirtualFile[] virtualFiles = new VirtualFile[hdfsVirtualFiles.size()];
        for (int i = 0; i < virtualFiles.length; ++i) {
            virtualFiles[i] = (VirtualFile)hdfsVirtualFiles.get(i);
        }
        return virtualFiles;
    }

    public void add(InputStream inputStream, String s) throws TranslatorException {
        try {
            FSDataOutputStream out = this.fileSystem.create(new Path(s));
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)out, (int)131072);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public boolean remove(String s) throws TranslatorException {
        try {
            return this.fileSystem.delete(new Path(s), false);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void close() {
    }
}

