/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SSECustomerKey;
import java.io.InputStream;
import java.util.ArrayList;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.s3.S3Configuration;
import org.teiid.s3.S3VirtualFile;
import org.teiid.translator.TranslatorException;

public class S3Connection
implements VirtualFileConnection {
    private static final String STAR = "*";
    private static final String SLASH = "/";
    private final S3Configuration s3Config;
    private final AmazonS3 s3Client;

    public S3Connection(S3Configuration s3Config, AmazonS3 s3Client) {
        this.s3Config = s3Config;
        this.s3Client = s3Client;
    }

    public VirtualFile[] getFiles(String s) throws TranslatorException {
        if (s == null) {
            return null;
        }
        if (this.s3Client.doesObjectExist(this.s3Config.getBucket(), s)) {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.s3Config.getBucket()).withPrefix(s);
            ObjectListing objectListing = this.s3Client.listObjects(listObjectsRequest);
            return new VirtualFile[]{new S3VirtualFile(this.s3Client, (S3ObjectSummary)objectListing.getObjectSummaries().get(0), this.s3Config)};
        }
        if (this.isDirectory(s)) {
            if (!s.isEmpty() && !s.endsWith(SLASH)) {
                s = s + SLASH;
            }
            return this.convert(s);
        }
        String parentPath = "";
        if (s.contains(SLASH)) {
            parentPath = s.substring(0, s.lastIndexOf(SLASH) + 1);
        }
        if (!this.isDirectory(parentPath)) {
            return null;
        }
        if (s.contains(STAR)) {
            return this.globSearch(parentPath, s);
        }
        return null;
    }

    private VirtualFile[] globSearch(String parentPath, String s) {
        ArrayList<S3VirtualFile> s3VirtualFiles = new ArrayList<S3VirtualFile>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.s3Config.getBucket()).withPrefix(parentPath).withDelimiter(SLASH);
        ObjectListing objectListing = this.s3Client.listObjects(listObjectsRequest);
        while (objectListing != null) {
            for (S3ObjectSummary s3ObjectSummary : objectListing.getObjectSummaries()) {
                if (s3ObjectSummary.getKey().endsWith(SLASH) || !this.matchString(s3ObjectSummary.getKey(), s)) continue;
                s3VirtualFiles.add(new S3VirtualFile(this.s3Client, s3ObjectSummary, this.s3Config));
            }
            if (!objectListing.isTruncated()) break;
            objectListing = this.s3Client.listNextBatchOfObjects(objectListing);
        }
        return s3VirtualFiles.toArray(new VirtualFile[s3VirtualFiles.size()]);
    }

    protected boolean matchString(String key, String pattern) {
        String slicedKey = key.contains(SLASH) ? key.substring(key.lastIndexOf(SLASH) + 1) : key;
        String slicedPattern = pattern.contains(SLASH) ? pattern.substring(pattern.lastIndexOf(SLASH) + 1) : pattern;
        if (slicedPattern.endsWith(STAR)) {
            return slicedKey.startsWith(slicedPattern.substring(0, slicedPattern.length() - 1));
        }
        if (slicedPattern.startsWith(STAR)) {
            return slicedKey.endsWith(slicedPattern.substring(1));
        }
        int index0fAsterisk = slicedPattern.indexOf(STAR);
        String begin = slicedPattern.substring(0, index0fAsterisk);
        String end = slicedPattern.substring(index0fAsterisk + 1);
        return slicedKey.startsWith(begin) && slicedKey.endsWith(end) && slicedPattern.lastIndexOf(end) > slicedPattern.indexOf(begin) + begin.length() - 1;
    }

    private VirtualFile[] convert(String s) {
        ArrayList<S3VirtualFile> s3VirtualFiles = new ArrayList<S3VirtualFile>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.s3Config.getBucket()).withPrefix(s).withDelimiter(SLASH);
        ObjectListing objectListing = this.s3Client.listObjects(listObjectsRequest);
        while (objectListing != null) {
            for (S3ObjectSummary s3ObjectSummary : objectListing.getObjectSummaries()) {
                if (s3ObjectSummary.getKey().endsWith(SLASH)) continue;
                s3VirtualFiles.add(new S3VirtualFile(this.s3Client, s3ObjectSummary, this.s3Config));
            }
            if (!objectListing.isTruncated()) break;
            objectListing = this.s3Client.listNextBatchOfObjects(objectListing);
        }
        return s3VirtualFiles.toArray(new VirtualFile[s3VirtualFiles.size()]);
    }

    private boolean isDirectory(String s) {
        ListObjectsRequest listObjectsRequest;
        ObjectListing objectListing;
        if (!s.endsWith(SLASH)) {
            s = s + SLASH;
        }
        return (objectListing = this.s3Client.listObjects(listObjectsRequest = new ListObjectsRequest().withBucketName(this.s3Config.getBucket()).withPrefix(s))).getObjectSummaries().size() > 0;
    }

    public void add(InputStream in, String path) throws TranslatorException {
        this.add(in, path, null);
    }

    public void add(InputStream inputStream, String s, VirtualFileConnection.FileMetadata fileMetadata) throws TranslatorException {
        ObjectMetadata metadata = new ObjectMetadata();
        try {
            Long size;
            if (fileMetadata != null && (size = fileMetadata.size()) != null) {
                metadata.setContentLength(size.longValue());
            }
            PutObjectRequest request = new PutObjectRequest(this.s3Config.getBucket(), s, inputStream, metadata);
            if (this.s3Config.getSseKey() != null) {
                request.withSSECustomerKey(new SSECustomerKey(this.s3Config.getSseKey()).withAlgorithm(this.s3Config.getSseAlgorithm()));
            }
            this.s3Client.putObject(request);
        }
        catch (SdkClientException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public boolean remove(String s) throws TranslatorException {
        try {
            if (!this.s3Client.doesObjectExist(this.s3Config.getBucket(), s)) {
                return false;
            }
            this.s3Client.deleteObject(this.s3Config.getBucket(), s);
        }
        catch (SdkClientException e) {
            return false;
        }
        return true;
    }

    public void close() {
    }
}

