/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.s3;

import com.amazonaws.SdkClientException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.file.VirtualFile;
import org.teiid.s3.S3Configuration;
import org.teiid.s3.S3Connection;
import org.teiid.s3.S3ConnectionFactory;
import org.teiid.translator.TranslatorException;

@Ignore
public class IntegrationTestS3 {
    private S3Connection s3Connection;

    @Before
    public void setUp() throws TranslatorException {
        S3Configuration config = new S3Configuration(){

            public String getSseKey() {
                return null;
            }

            public String getSseAlgorithm() {
                return null;
            }

            public String getSecretKey() {
                return "wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY";
            }

            public String getRegion() {
                return null;
            }

            public String getEndpoint() {
                return "http://localhost:9000";
            }

            public String getBucket() {
                return "bucket";
            }

            public String getAccessKey() {
                return "AKIAIOSFODNN7EXAMPLE";
            }
        };
        S3ConnectionFactory s3ConnectionFactory = new S3ConnectionFactory(config);
        if (!s3ConnectionFactory.getS3Client().doesBucketExistV2("bucket")) {
            s3ConnectionFactory.getS3Client().createBucket("bucket");
        }
        this.s3Connection = new S3Connection(s3ConnectionFactory.getS3Config(), s3ConnectionFactory.getS3Client());
    }

    @Test
    public void testSearch() throws SdkClientException, TranslatorException {
        this.s3Connection.add((InputStream)new ByteArrayInputStream(new byte[0]), "some/directory/file");
        this.s3Connection.add((InputStream)new ByteArrayInputStream(new byte[0]), "some/directory/file.txt");
        this.s3Connection.add((InputStream)new ByteArrayInputStream(new byte[0]), "some/directory/file2.txt");
        this.s3Connection.add((InputStream)new ByteArrayInputStream(new byte[0]), "some/directory/x/filex.txt");
        this.s3Connection.add((InputStream)new ByteArrayInputStream(new byte[0]), "some/directory/*/filex.txt");
        this.s3Connection.add((InputStream)new ByteArrayInputStream(new byte[0]), "some/otherdir/file3.txt");
        this.s3Connection.add((InputStream)new ByteArrayInputStream(new byte[0]), "some/nested/directory/file4.txt");
        VirtualFile[] files = this.s3Connection.getFiles("some");
        Assert.assertEquals((long)0L, (long)files.length);
        files = this.s3Connection.getFiles("some/directory/file");
        Assert.assertEquals((long)1L, (long)files.length);
        Assert.assertEquals((Object)"some/directory/file", (Object)files[0].getPath());
        files = this.s3Connection.getFiles("some/directory");
        Assert.assertEquals((long)3L, (long)files.length);
        files = this.s3Connection.getFiles("some/directory/");
        Assert.assertEquals((long)3L, (long)files.length);
        files = this.s3Connection.getFiles("some/directory*");
        Assert.assertEquals((long)0L, (long)files.length);
        files = this.s3Connection.getFiles("some/directory/*");
        Assert.assertEquals((long)3L, (long)files.length);
        Assert.assertEquals((Object)"some/directory/file", (Object)files[0].getPath());
        files = this.s3Connection.getFiles("some/directory/file.txt");
        Assert.assertEquals((long)1L, (long)files.length);
        Assert.assertEquals((Object)"some/directory/file.txt", (Object)files[0].getPath());
        files = this.s3Connection.getFiles("some/directory/**/filex.txt");
        Assert.assertEquals((long)1L, (long)files.length);
        Assert.assertEquals((Object)"some/directory/*/filex.txt", (Object)files[0].getPath());
        files = this.s3Connection.getFiles("some/*/*.txt");
        Assert.assertEquals((long)3L, (long)files.length);
        files = this.s3Connection.getFiles("*/nested/*/*.txt");
        Assert.assertEquals((long)1L, (long)files.length);
        Assert.assertEquals((Object)"file4.txt", (Object)files[0].getName());
    }

    @After
    public void close() throws Exception {
        this.s3Connection.close();
    }
}

