/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.file.VirtualFile;
import org.teiid.s3.S3Configuration;
import org.teiid.s3.S3Connection;
import org.teiid.translator.TranslatorException;

public class TestS3Connection {
    private S3Connection s3Connection;
    private AmazonS3Client amazonS3Client = (AmazonS3Client)Mockito.mock(AmazonS3Client.class);

    @Before
    public void setUp() {
        this.s3Connection = new S3Connection((S3Configuration)Mockito.mock(S3Configuration.class), (AmazonS3)this.amazonS3Client);
    }

    @Test
    public void testAdd() throws SdkClientException, TranslatorException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        this.s3Connection.add(inputStream, "");
    }

    @Test
    public void testDeleteFile() throws TranslatorException {
        Assert.assertFalse((boolean)this.s3Connection.remove("sl"));
    }

    @Test
    public void testGetFilesAndConvert() throws TranslatorException {
        ObjectListing objectListing = (ObjectListing)Mockito.mock(ObjectListing.class);
        Mockito.when((Object)this.amazonS3Client.listObjects((ListObjectsRequest)Mockito.any(ListObjectsRequest.class))).thenReturn((Object)objectListing);
        ArrayList<S3ObjectSummary> objectSummaryList = new ArrayList<S3ObjectSummary>();
        S3ObjectSummary summary1 = (S3ObjectSummary)Mockito.mock(S3ObjectSummary.class);
        S3ObjectSummary summary2 = (S3ObjectSummary)Mockito.mock(S3ObjectSummary.class);
        Mockito.when((Object)summary1.getKey()).thenReturn((Object)"folder1/folder2/file");
        Mockito.when((Object)summary2.getKey()).thenReturn((Object)"folder1/folder2/file1");
        objectSummaryList.add(summary1);
        objectSummaryList.add(summary2);
        Mockito.when((Object)objectListing.getObjectSummaries()).thenReturn(objectSummaryList);
        VirtualFile[] virtualFiles = this.s3Connection.getFiles("folder1/folder2");
        Assert.assertEquals((long)2L, (long)virtualFiles.length);
        virtualFiles = this.s3Connection.getFiles("folder1/folder2/");
        Assert.assertEquals((long)2L, (long)virtualFiles.length);
    }

    @Test
    public void testMatchString() {
        Assert.assertTrue((boolean)this.matchString("folder1/sample", "folder1/samp*"));
        Assert.assertTrue((boolean)this.matchString("dddd", "dd*d"));
        Assert.assertTrue((boolean)this.matchString("folder1/sample", "folder1/*le"));
        Assert.assertFalse((boolean)this.matchString("folder1/sample", "folder1/**le"));
        Assert.assertTrue((boolean)this.matchString("folder1/*le", "folder1/**le"));
        Assert.assertFalse((boolean)this.matchString("folder1/sample", "folder1/san*"));
        Assert.assertTrue((boolean)this.matchString("year=2020/month=January/week=1/day=Monday", "year=2020/*/*/day=Monday"));
        Assert.assertTrue((boolean)this.matchString("year=2020/month=January/week=1/day=Monday", "year=2020/month=*/*/day=Monday"));
        Assert.assertTrue((boolean)this.matchString("year=2020/month=January/week=1/day=Monday", "year=2020/*/*/*"));
        Assert.assertFalse((boolean)this.matchString("year=2020/month=January/week=1/day=Monday", "year=2020/*/*/day=Mondays"));
        Assert.assertFalse((boolean)this.matchString("year=2020/month=January/week=1/day=Monday/page=1", "year=2020/*/*/*"));
        Assert.assertTrue((boolean)this.matchString("year=2020/month=January/week=1/day=Monday", "year=2020/month=*Jan*/*/day=Mo*day"));
        Assert.assertFalse((boolean)this.matchString("year=2020/month=January/jkl=fyz/week=1/day=Monday", "year=2020/month=*/*/day=Monday"));
        Assert.assertFalse((boolean)this.matchString("year=2020/month=January/week=1/day=Mondays", "year=2020/*/*/day=Monday"));
    }

    @After
    public void close() throws Exception {
        this.s3Connection.close();
    }

    protected boolean matchString(String key, String remainingPath) {
        Pattern pattern = this.s3Connection.convertPathToPattern(remainingPath);
        return pattern.matcher(key).matches();
    }
}

