/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SSECustomerKey;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.s3.S3Configuration;
import org.teiid.s3.S3VirtualFile;
import org.teiid.translator.TranslatorException;

public class S3Connection
implements VirtualFileConnection {
    private static final char STAR = '*';
    static final String SLASH = "/";
    private final S3Configuration s3Config;
    private final AmazonS3 s3Client;

    public S3Connection(S3Configuration s3Config, AmazonS3 s3Client) {
        this.s3Config = s3Config;
        this.s3Client = s3Client;
    }

    public VirtualFile[] getFiles(String s) throws TranslatorException {
        if (s == null) {
            return null;
        }
        return this.search(s);
    }

    private VirtualFile[] search(String s) {
        int firstStar = s.indexOf(42);
        String prefix = s;
        String remainingPath = "";
        while (firstStar != -1) {
            prefix = s.substring(0, firstStar);
            remainingPath = s.substring(firstStar, s.length());
            if (remainingPath.length() < 2 || remainingPath.charAt(1) != '*') break;
            prefix = prefix + '*';
            remainingPath = remainingPath.substring(2);
            firstStar = remainingPath.indexOf(42);
        }
        ArrayList<S3VirtualFile> s3VirtualFiles = new ArrayList<S3VirtualFile>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.s3Config.getBucket()).withPrefix(prefix);
        ObjectListing objectListing = this.s3Client.listObjects(listObjectsRequest);
        Pattern pattern = this.convertPathToPattern(remainingPath);
        while (objectListing != null) {
            for (S3ObjectSummary s3ObjectSummary : objectListing.getObjectSummaries()) {
                String remainingKey = s3ObjectSummary.getKey().substring(prefix.length());
                if ((!remainingPath.isEmpty() || !prefix.endsWith(SLASH) && !remainingKey.startsWith(SLASH) || remainingKey.lastIndexOf(47) >= 1) && !pattern.matcher(remainingKey).matches()) continue;
                s3VirtualFiles.add(new S3VirtualFile(this.s3Client, s3ObjectSummary, this.s3Config));
            }
            if (!objectListing.isTruncated()) break;
            objectListing = this.s3Client.listNextBatchOfObjects(objectListing);
        }
        return s3VirtualFiles.toArray(new VirtualFile[s3VirtualFiles.size()]);
    }

    Pattern convertPathToPattern(String remainingPath) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < remainingPath.length(); ++index) {
            int startIndex = index;
            int endIndex = index = remainingPath.indexOf(42, index);
            if (index == -1) {
                endIndex = remainingPath.length();
            }
            String literal = remainingPath.substring(startIndex, endIndex);
            builder.append(Pattern.quote(literal));
            if (index == -1) break;
            if (index < remainingPath.length() - 1 && remainingPath.charAt(index + 1) == '*') {
                ++index;
                builder.append("[*]");
                continue;
            }
            builder.append("[^/]*");
        }
        builder.append("$");
        Pattern pattern = Pattern.compile(builder.toString());
        return pattern;
    }

    public void add(InputStream in, String path) throws TranslatorException {
        this.add(in, path, null);
    }

    public void add(InputStream inputStream, String s, VirtualFileConnection.FileMetadata fileMetadata) throws TranslatorException {
        ObjectMetadata metadata = new ObjectMetadata();
        try {
            Long size;
            if (fileMetadata != null && (size = fileMetadata.size()) != null) {
                metadata.setContentLength(size.longValue());
            }
            PutObjectRequest request = new PutObjectRequest(this.s3Config.getBucket(), s, inputStream, metadata);
            if (this.s3Config.getSseKey() != null) {
                request.withSSECustomerKey(new SSECustomerKey(this.s3Config.getSseKey()).withAlgorithm(this.s3Config.getSseAlgorithm()));
            }
            this.s3Client.putObject(request);
        }
        catch (SdkClientException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public boolean remove(String s) throws TranslatorException {
        try {
            if (!this.s3Client.doesObjectExist(this.s3Config.getBucket(), s)) {
                return false;
            }
            this.s3Client.deleteObject(this.s3Config.getBucket(), s);
        }
        catch (SdkClientException e) {
            return false;
        }
        return true;
    }

    public void close() {
    }
}

