/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.teiid.s3.S3Configuration;
import org.teiid.translator.TranslatorException;

public class S3ConnectionFactory {
    private AmazonS3 s3Client;
    private S3Configuration s3Config;

    public S3ConnectionFactory(S3Configuration s3Config) throws TranslatorException {
        this.s3Config = s3Config;
        if (s3Config.getBucket() == null) {
            throw new TranslatorException("Bucket can't be null.");
        }
        if (s3Config.getAccessKey() == null) {
            throw new TranslatorException("Access key can't be null.");
        }
        if (s3Config.getSecretKey() == null) {
            throw new TranslatorException("Secret key can't be null.");
        }
        BasicAWSCredentials credentials = new BasicAWSCredentials(s3Config.getAccessKey(), s3Config.getSecretKey());
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setSignerOverride("AWSS3V4SignerType");
        AmazonS3ClientBuilder standard = AmazonS3ClientBuilder.standard();
        if (s3Config.getEndpoint() != null) {
            standard = (AmazonS3ClientBuilder)standard.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(s3Config.getEndpoint(), s3Config.getRegion()));
        } else if (s3Config.getRegion() != null) {
            standard = (AmazonS3ClientBuilder)standard.withRegion(s3Config.getRegion());
        }
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)standard.withPathStyleAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).build();
    }

    public void close() {
        this.s3Client.shutdown();
    }

    public AmazonS3 getS3Client() {
        return this.s3Client;
    }

    public S3Configuration getS3Config() {
        return this.s3Config;
    }
}

