/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SSECustomerKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.teiid.file.VirtualFile;
import org.teiid.s3.S3Configuration;

public class S3VirtualFile
implements VirtualFile {
    AmazonS3 s3Client;
    S3ObjectSummary summary;
    S3Configuration s3Config;

    public S3VirtualFile(AmazonS3 s3Client, S3ObjectSummary s3ObjectSummary, S3Configuration s3Config) {
        this.s3Client = s3Client;
        this.summary = s3ObjectSummary;
        this.s3Config = s3Config;
    }

    public String getPath() {
        String result = this.summary.getKey();
        if (this.isDirectory()) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    public boolean isDirectory() {
        return this.summary.getKey().endsWith("/");
    }

    public String getName() {
        String path = this.getPath();
        int index = path.lastIndexOf(47);
        if (index != -1) {
            return path.substring(index + 1);
        }
        return path;
    }

    public InputStream openInputStream(boolean b) throws IOException {
        GetObjectRequest request = new GetObjectRequest(this.summary.getBucketName(), this.summary.getKey());
        if (this.s3Config.getSseKey() != null) {
            request.withSSECustomerKey(new SSECustomerKey(this.s3Config.getSseKey()).withAlgorithm(this.s3Config.getSseAlgorithm()));
        }
        S3Object object = this.s3Client.getObject(request);
        return object.getObjectContent();
    }

    public OutputStream openOutputStream(boolean b) throws IOException {
        throw new IOException("Output stream is not supported for use in s3.");
    }

    public long getLastModified() {
        return this.summary.getLastModified().getTime();
    }

    public long getCreationTime() {
        return this.summary.getLastModified().getTime();
    }

    public long getSize() {
        return this.summary.getSize();
    }
}

