/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.infinispan.server.tasks;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.tasks.ServerTask;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecutionMode;

public class BulkInsertTask
implements ServerTask<Long> {
    private TaskContext ctx;

    public void setTaskContext(TaskContext ctx) {
        this.ctx = ctx;
    }

    public String getName() {
        return "teiid-bulk-insert";
    }

    public Long call() throws Exception {
        Cache cache = this.getCache();
        Map params = null;
        if (this.ctx.getParameters().isPresent()) {
            params = (Map)this.ctx.getParameters().get();
        }
        if (params == null) {
            return -1L;
        }
        boolean upsert = Boolean.parseBoolean((String)params.get("upsert"));
        int rowCount = (Integer)params.get("row-count");
        long updateCount = 0L;
        for (int i = 0; i < rowCount; ++i) {
            Object key = params.get("row-key-" + i);
            Object value = params.get("row-" + i);
            Object previous = cache.get(key);
            if (previous != null) {
                if (upsert) {
                    throw new Exception("not currently supported");
                }
                throw new Exception("row already exists");
            }
            cache.put(key, value);
            ++updateCount;
        }
        return updateCount;
    }

    public TaskExecutionMode getExecutionMode() {
        return TaskExecutionMode.ONE_NODE;
    }

    private <K, V> Cache<K, V> getCache() {
        return (Cache)this.ctx.getCache().get();
    }
}

